/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codestar;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.codestar.CodeStarClient;
import software.amazon.awssdk.services.codestar.CodeStarClientBuilder;
import software.amazon.awssdk.services.codestar.CodeStarServiceClientConfiguration;
import software.amazon.awssdk.services.codestar.DefaultCodeStarBaseClientBuilder;
import software.amazon.awssdk.services.codestar.DefaultCodeStarClient;
import software.amazon.awssdk.services.codestar.endpoints.CodeStarEndpointProvider;

@SdkInternalApi
final class DefaultCodeStarClientBuilder
extends DefaultCodeStarBaseClientBuilder<CodeStarClientBuilder, CodeStarClient>
implements CodeStarClientBuilder {
    DefaultCodeStarClientBuilder() {
    }

    @Override
    public DefaultCodeStarClientBuilder endpointProvider(CodeStarEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final CodeStarClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultCodeStarClientBuilder.validateClientOptions(clientConfiguration);
        CodeStarServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultCodeStarClient client = new DefaultCodeStarClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private CodeStarServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        EndpointProvider endpointProvider = (EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER);
        if (clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return CodeStarServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider(endpointProvider).build();
    }
}

