/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codepipeline.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents information about the state of an action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ActionState implements SdkPojo, Serializable, ToCopyableBuilder<ActionState.Builder, ActionState> {
    private static final SdkField<String> ACTION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("actionName").getter(getter(ActionState::actionName)).setter(setter(Builder::actionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionName").build()).build();

    private static final SdkField<ActionRevision> CURRENT_REVISION_FIELD = SdkField
            .<ActionRevision> builder(MarshallingType.SDK_POJO).memberName("currentRevision")
            .getter(getter(ActionState::currentRevision)).setter(setter(Builder::currentRevision))
            .constructor(ActionRevision::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("currentRevision").build()).build();

    private static final SdkField<ActionExecution> LATEST_EXECUTION_FIELD = SdkField
            .<ActionExecution> builder(MarshallingType.SDK_POJO).memberName("latestExecution")
            .getter(getter(ActionState::latestExecution)).setter(setter(Builder::latestExecution))
            .constructor(ActionExecution::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("latestExecution").build()).build();

    private static final SdkField<String> ENTITY_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("entityUrl").getter(getter(ActionState::entityUrl)).setter(setter(Builder::entityUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entityUrl").build()).build();

    private static final SdkField<String> REVISION_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("revisionUrl").getter(getter(ActionState::revisionUrl)).setter(setter(Builder::revisionUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("revisionUrl").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_NAME_FIELD,
            CURRENT_REVISION_FIELD, LATEST_EXECUTION_FIELD, ENTITY_URL_FIELD, REVISION_URL_FIELD));

    private static final long serialVersionUID = 1L;

    private final String actionName;

    private final ActionRevision currentRevision;

    private final ActionExecution latestExecution;

    private final String entityUrl;

    private final String revisionUrl;

    private ActionState(BuilderImpl builder) {
        this.actionName = builder.actionName;
        this.currentRevision = builder.currentRevision;
        this.latestExecution = builder.latestExecution;
        this.entityUrl = builder.entityUrl;
        this.revisionUrl = builder.revisionUrl;
    }

    /**
     * <p>
     * The name of the action.
     * </p>
     * 
     * @return The name of the action.
     */
    public final String actionName() {
        return actionName;
    }

    /**
     * <p>
     * Represents information about the version (or revision) of an action.
     * </p>
     * 
     * @return Represents information about the version (or revision) of an action.
     */
    public final ActionRevision currentRevision() {
        return currentRevision;
    }

    /**
     * <p>
     * Represents information about the run of an action.
     * </p>
     * 
     * @return Represents information about the run of an action.
     */
    public final ActionExecution latestExecution() {
        return latestExecution;
    }

    /**
     * <p>
     * A URL link for more information about the state of the action, such as a deployment group details page.
     * </p>
     * 
     * @return A URL link for more information about the state of the action, such as a deployment group details page.
     */
    public final String entityUrl() {
        return entityUrl;
    }

    /**
     * <p>
     * A URL link for more information about the revision, such as a commit details page.
     * </p>
     * 
     * @return A URL link for more information about the revision, such as a commit details page.
     */
    public final String revisionUrl() {
        return revisionUrl;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(actionName());
        hashCode = 31 * hashCode + Objects.hashCode(currentRevision());
        hashCode = 31 * hashCode + Objects.hashCode(latestExecution());
        hashCode = 31 * hashCode + Objects.hashCode(entityUrl());
        hashCode = 31 * hashCode + Objects.hashCode(revisionUrl());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ActionState)) {
            return false;
        }
        ActionState other = (ActionState) obj;
        return Objects.equals(actionName(), other.actionName()) && Objects.equals(currentRevision(), other.currentRevision())
                && Objects.equals(latestExecution(), other.latestExecution()) && Objects.equals(entityUrl(), other.entityUrl())
                && Objects.equals(revisionUrl(), other.revisionUrl());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ActionState").add("ActionName", actionName()).add("CurrentRevision", currentRevision())
                .add("LatestExecution", latestExecution()).add("EntityUrl", entityUrl()).add("RevisionUrl", revisionUrl())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "actionName":
            return Optional.ofNullable(clazz.cast(actionName()));
        case "currentRevision":
            return Optional.ofNullable(clazz.cast(currentRevision()));
        case "latestExecution":
            return Optional.ofNullable(clazz.cast(latestExecution()));
        case "entityUrl":
            return Optional.ofNullable(clazz.cast(entityUrl()));
        case "revisionUrl":
            return Optional.ofNullable(clazz.cast(revisionUrl()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ActionState, T> g) {
        return obj -> g.apply((ActionState) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ActionState> {
        /**
         * <p>
         * The name of the action.
         * </p>
         * 
         * @param actionName
         *        The name of the action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actionName(String actionName);

        /**
         * <p>
         * Represents information about the version (or revision) of an action.
         * </p>
         * 
         * @param currentRevision
         *        Represents information about the version (or revision) of an action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currentRevision(ActionRevision currentRevision);

        /**
         * <p>
         * Represents information about the version (or revision) of an action.
         * </p>
         * This is a convenience method that creates an instance of the {@link ActionRevision.Builder} avoiding the need
         * to create one manually via {@link ActionRevision#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ActionRevision.Builder#build()} is called immediately and its
         * result is passed to {@link #currentRevision(ActionRevision)}.
         * 
         * @param currentRevision
         *        a consumer that will call methods on {@link ActionRevision.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #currentRevision(ActionRevision)
         */
        default Builder currentRevision(Consumer<ActionRevision.Builder> currentRevision) {
            return currentRevision(ActionRevision.builder().applyMutation(currentRevision).build());
        }

        /**
         * <p>
         * Represents information about the run of an action.
         * </p>
         * 
         * @param latestExecution
         *        Represents information about the run of an action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder latestExecution(ActionExecution latestExecution);

        /**
         * <p>
         * Represents information about the run of an action.
         * </p>
         * This is a convenience method that creates an instance of the {@link ActionExecution.Builder} avoiding the
         * need to create one manually via {@link ActionExecution#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ActionExecution.Builder#build()} is called immediately and its
         * result is passed to {@link #latestExecution(ActionExecution)}.
         * 
         * @param latestExecution
         *        a consumer that will call methods on {@link ActionExecution.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #latestExecution(ActionExecution)
         */
        default Builder latestExecution(Consumer<ActionExecution.Builder> latestExecution) {
            return latestExecution(ActionExecution.builder().applyMutation(latestExecution).build());
        }

        /**
         * <p>
         * A URL link for more information about the state of the action, such as a deployment group details page.
         * </p>
         * 
         * @param entityUrl
         *        A URL link for more information about the state of the action, such as a deployment group details
         *        page.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entityUrl(String entityUrl);

        /**
         * <p>
         * A URL link for more information about the revision, such as a commit details page.
         * </p>
         * 
         * @param revisionUrl
         *        A URL link for more information about the revision, such as a commit details page.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder revisionUrl(String revisionUrl);
    }

    static final class BuilderImpl implements Builder {
        private String actionName;

        private ActionRevision currentRevision;

        private ActionExecution latestExecution;

        private String entityUrl;

        private String revisionUrl;

        private BuilderImpl() {
        }

        private BuilderImpl(ActionState model) {
            actionName(model.actionName);
            currentRevision(model.currentRevision);
            latestExecution(model.latestExecution);
            entityUrl(model.entityUrl);
            revisionUrl(model.revisionUrl);
        }

        public final String getActionName() {
            return actionName;
        }

        public final void setActionName(String actionName) {
            this.actionName = actionName;
        }

        @Override
        public final Builder actionName(String actionName) {
            this.actionName = actionName;
            return this;
        }

        public final ActionRevision.Builder getCurrentRevision() {
            return currentRevision != null ? currentRevision.toBuilder() : null;
        }

        public final void setCurrentRevision(ActionRevision.BuilderImpl currentRevision) {
            this.currentRevision = currentRevision != null ? currentRevision.build() : null;
        }

        @Override
        public final Builder currentRevision(ActionRevision currentRevision) {
            this.currentRevision = currentRevision;
            return this;
        }

        public final ActionExecution.Builder getLatestExecution() {
            return latestExecution != null ? latestExecution.toBuilder() : null;
        }

        public final void setLatestExecution(ActionExecution.BuilderImpl latestExecution) {
            this.latestExecution = latestExecution != null ? latestExecution.build() : null;
        }

        @Override
        public final Builder latestExecution(ActionExecution latestExecution) {
            this.latestExecution = latestExecution;
            return this;
        }

        public final String getEntityUrl() {
            return entityUrl;
        }

        public final void setEntityUrl(String entityUrl) {
            this.entityUrl = entityUrl;
        }

        @Override
        public final Builder entityUrl(String entityUrl) {
            this.entityUrl = entityUrl;
            return this;
        }

        public final String getRevisionUrl() {
            return revisionUrl;
        }

        public final void setRevisionUrl(String revisionUrl) {
            this.revisionUrl = revisionUrl;
        }

        @Override
        public final Builder revisionUrl(String revisionUrl) {
            this.revisionUrl = revisionUrl;
            return this;
        }

        @Override
        public ActionState build() {
            return new ActionState(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
