/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codeguruprofiler.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The structure representing the SubmitFeedbackRequest.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SubmitFeedbackRequest extends CodeGuruProfilerRequest implements
        ToCopyableBuilder<SubmitFeedbackRequest.Builder, SubmitFeedbackRequest> {
    private static final SdkField<String> ANOMALY_INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("anomalyInstanceId").getter(getter(SubmitFeedbackRequest::anomalyInstanceId))
            .setter(setter(Builder::anomalyInstanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("anomalyInstanceId").build()).build();

    private static final SdkField<String> COMMENT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("comment")
            .getter(getter(SubmitFeedbackRequest::comment)).setter(setter(Builder::comment))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("comment").build()).build();

    private static final SdkField<String> PROFILING_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("profilingGroupName").getter(getter(SubmitFeedbackRequest::profilingGroupName))
            .setter(setter(Builder::profilingGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("profilingGroupName").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(SubmitFeedbackRequest::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ANOMALY_INSTANCE_ID_FIELD,
            COMMENT_FIELD, PROFILING_GROUP_NAME_FIELD, TYPE_FIELD));

    private final String anomalyInstanceId;

    private final String comment;

    private final String profilingGroupName;

    private final String type;

    private SubmitFeedbackRequest(BuilderImpl builder) {
        super(builder);
        this.anomalyInstanceId = builder.anomalyInstanceId;
        this.comment = builder.comment;
        this.profilingGroupName = builder.profilingGroupName;
        this.type = builder.type;
    }

    /**
     * <p>
     * The universally unique identifier (UUID) of the <a
     * href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_AnomalyInstance.html">
     * <code>AnomalyInstance</code> </a> object that is included in the analysis data.
     * </p>
     * 
     * @return The universally unique identifier (UUID) of the <a
     *         href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_AnomalyInstance.html">
     *         <code>AnomalyInstance</code> </a> object that is included in the analysis data.
     */
    public final String anomalyInstanceId() {
        return anomalyInstanceId;
    }

    /**
     * <p>
     * Optional feedback about this anomaly.
     * </p>
     * 
     * @return Optional feedback about this anomaly.
     */
    public final String comment() {
        return comment;
    }

    /**
     * <p>
     * The name of the profiling group that is associated with the analysis data.
     * </p>
     * 
     * @return The name of the profiling group that is associated with the analysis data.
     */
    public final String profilingGroupName() {
        return profilingGroupName;
    }

    /**
     * <p>
     * The feedback tpye. Thee are two valid values, <code>Positive</code> and <code>Negative</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link FeedbackType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The feedback tpye. Thee are two valid values, <code>Positive</code> and <code>Negative</code>.
     * @see FeedbackType
     */
    public final FeedbackType type() {
        return FeedbackType.fromValue(type);
    }

    /**
     * <p>
     * The feedback tpye. Thee are two valid values, <code>Positive</code> and <code>Negative</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link FeedbackType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The feedback tpye. Thee are two valid values, <code>Positive</code> and <code>Negative</code>.
     * @see FeedbackType
     */
    public final String typeAsString() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(anomalyInstanceId());
        hashCode = 31 * hashCode + Objects.hashCode(comment());
        hashCode = 31 * hashCode + Objects.hashCode(profilingGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SubmitFeedbackRequest)) {
            return false;
        }
        SubmitFeedbackRequest other = (SubmitFeedbackRequest) obj;
        return Objects.equals(anomalyInstanceId(), other.anomalyInstanceId()) && Objects.equals(comment(), other.comment())
                && Objects.equals(profilingGroupName(), other.profilingGroupName())
                && Objects.equals(typeAsString(), other.typeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SubmitFeedbackRequest").add("AnomalyInstanceId", anomalyInstanceId()).add("Comment", comment())
                .add("ProfilingGroupName", profilingGroupName()).add("Type", typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "anomalyInstanceId":
            return Optional.ofNullable(clazz.cast(anomalyInstanceId()));
        case "comment":
            return Optional.ofNullable(clazz.cast(comment()));
        case "profilingGroupName":
            return Optional.ofNullable(clazz.cast(profilingGroupName()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SubmitFeedbackRequest, T> g) {
        return obj -> g.apply((SubmitFeedbackRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeGuruProfilerRequest.Builder, SdkPojo, CopyableBuilder<Builder, SubmitFeedbackRequest> {
        /**
         * <p>
         * The universally unique identifier (UUID) of the <a
         * href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_AnomalyInstance.html">
         * <code>AnomalyInstance</code> </a> object that is included in the analysis data.
         * </p>
         * 
         * @param anomalyInstanceId
         *        The universally unique identifier (UUID) of the <a
         *        href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_AnomalyInstance.html">
         *        <code>AnomalyInstance</code> </a> object that is included in the analysis data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder anomalyInstanceId(String anomalyInstanceId);

        /**
         * <p>
         * Optional feedback about this anomaly.
         * </p>
         * 
         * @param comment
         *        Optional feedback about this anomaly.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder comment(String comment);

        /**
         * <p>
         * The name of the profiling group that is associated with the analysis data.
         * </p>
         * 
         * @param profilingGroupName
         *        The name of the profiling group that is associated with the analysis data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder profilingGroupName(String profilingGroupName);

        /**
         * <p>
         * The feedback tpye. Thee are two valid values, <code>Positive</code> and <code>Negative</code>.
         * </p>
         * 
         * @param type
         *        The feedback tpye. Thee are two valid values, <code>Positive</code> and <code>Negative</code>.
         * @see FeedbackType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FeedbackType
         */
        Builder type(String type);

        /**
         * <p>
         * The feedback tpye. Thee are two valid values, <code>Positive</code> and <code>Negative</code>.
         * </p>
         * 
         * @param type
         *        The feedback tpye. Thee are two valid values, <code>Positive</code> and <code>Negative</code>.
         * @see FeedbackType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FeedbackType
         */
        Builder type(FeedbackType type);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CodeGuruProfilerRequest.BuilderImpl implements Builder {
        private String anomalyInstanceId;

        private String comment;

        private String profilingGroupName;

        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(SubmitFeedbackRequest model) {
            super(model);
            anomalyInstanceId(model.anomalyInstanceId);
            comment(model.comment);
            profilingGroupName(model.profilingGroupName);
            type(model.type);
        }

        public final String getAnomalyInstanceId() {
            return anomalyInstanceId;
        }

        public final void setAnomalyInstanceId(String anomalyInstanceId) {
            this.anomalyInstanceId = anomalyInstanceId;
        }

        @Override
        public final Builder anomalyInstanceId(String anomalyInstanceId) {
            this.anomalyInstanceId = anomalyInstanceId;
            return this;
        }

        public final String getComment() {
            return comment;
        }

        public final void setComment(String comment) {
            this.comment = comment;
        }

        @Override
        public final Builder comment(String comment) {
            this.comment = comment;
            return this;
        }

        public final String getProfilingGroupName() {
            return profilingGroupName;
        }

        public final void setProfilingGroupName(String profilingGroupName) {
            this.profilingGroupName = profilingGroupName;
        }

        @Override
        public final Builder profilingGroupName(String profilingGroupName) {
            this.profilingGroupName = profilingGroupName;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(FeedbackType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SubmitFeedbackRequest build() {
            return new SubmitFeedbackRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
