/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.emitters;

import java.io.IOException;
import java.io.Writer;
import java.util.function.Supplier;
import software.amazon.awssdk.codegen.emitters.CodeWriter;
import software.amazon.awssdk.codegen.emitters.GeneratorTask;
import software.amazon.awssdk.codegen.internal.Utils;

public final class SimpleGeneratorTask
extends GeneratorTask {
    private final Writer writer;
    private final String fileHeader;
    private final String fileName;
    private final Supplier<String> contents;

    public SimpleGeneratorTask(String outputDirectory, String fileName, String fileHeader, Supplier<String> contents) {
        this.fileHeader = fileHeader;
        this.writer = new CodeWriter(outputDirectory, fileName);
        this.fileName = fileName;
        this.contents = contents;
    }

    public SimpleGeneratorTask(String outputDirectory, String fileName, String filenameSuffix, String fileHeader, Supplier<String> contents) {
        this.fileHeader = fileHeader;
        this.writer = new CodeWriter(outputDirectory, fileName, filenameSuffix, false);
        this.fileName = fileName;
        this.contents = contents;
    }

    @Override
    public void compute() {
        try {
            this.writer.write(this.fileHeader + "\n");
            this.writer.write(this.contents.get());
            this.writer.flush();
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Error creating file %s", this.fileName), e);
        }
        finally {
            Utils.closeQuietly(this.writer);
        }
    }
}

