/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.poet.model;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.TypeVariableName;
import com.squareup.javapoet.WildcardTypeName;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.lang.model.element.Modifier;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.codegen.docs.DocumentationBuilder;
import software.amazon.awssdk.codegen.internal.Utils;
import software.amazon.awssdk.codegen.model.intermediate.IntermediateModel;
import software.amazon.awssdk.codegen.model.intermediate.MemberModel;
import software.amazon.awssdk.codegen.model.intermediate.OperationModel;
import software.amazon.awssdk.codegen.model.intermediate.ShapeModel;
import software.amazon.awssdk.codegen.model.intermediate.ShapeType;
import software.amazon.awssdk.codegen.model.intermediate.VariableModel;
import software.amazon.awssdk.codegen.naming.NamingStrategy;
import software.amazon.awssdk.codegen.poet.ClassSpec;
import software.amazon.awssdk.codegen.poet.PoetExtension;
import software.amazon.awssdk.codegen.poet.PoetUtils;
import software.amazon.awssdk.codegen.poet.eventstream.EventStreamUtils;
import software.amazon.awssdk.codegen.poet.model.AwsServiceBaseRequestSpec;
import software.amazon.awssdk.codegen.poet.model.AwsServiceBaseResponseSpec;
import software.amazon.awssdk.codegen.poet.model.DeprecationUtils;
import software.amazon.awssdk.codegen.poet.model.EventStreamSpecHelper;
import software.amazon.awssdk.codegen.poet.model.MemberCopierSpec;
import software.amazon.awssdk.codegen.poet.model.ModelBuilderSpecs;
import software.amazon.awssdk.codegen.poet.model.ModelMethodOverrides;
import software.amazon.awssdk.codegen.poet.model.ServiceModelCopiers;
import software.amazon.awssdk.codegen.poet.model.ShapeModelSpec;
import software.amazon.awssdk.codegen.poet.model.TypeProvider;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.utils.StringUtils;
import software.amazon.awssdk.utils.Validate;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class AwsServiceModel
implements ClassSpec {
    private final IntermediateModel intermediateModel;
    private final ShapeModel shapeModel;
    private final PoetExtension poetExtensions;
    private final TypeProvider typeProvider;
    private final ShapeModelSpec shapeModelSpec;
    private final ModelBuilderSpecs modelBuilderSpecs;
    private final ServiceModelCopiers serviceModelCopiers;
    private final ModelMethodOverrides modelMethodOverrides;

    public AwsServiceModel(IntermediateModel intermediateModel, ShapeModel shapeModel) {
        this.intermediateModel = intermediateModel;
        this.shapeModel = shapeModel;
        this.poetExtensions = new PoetExtension(intermediateModel);
        this.typeProvider = new TypeProvider(intermediateModel);
        this.shapeModelSpec = new ShapeModelSpec(this.shapeModel, this.typeProvider, this.poetExtensions, intermediateModel);
        this.modelBuilderSpecs = this.resolveBuilderSpecs();
        this.serviceModelCopiers = new ServiceModelCopiers(this.intermediateModel);
        this.modelMethodOverrides = new ModelMethodOverrides(this.className(), this.poetExtensions);
    }

    @Override
    public TypeSpec poetSpec() {
        if (this.shapeModel.isEventStream()) {
            return this.eventStreamInterfaceSpec();
        }
        List<FieldSpec> fields = this.shapeModelSpec.fields();
        TypeSpec.Builder specBuilder = TypeSpec.classBuilder((ClassName)this.className()).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(PoetUtils.generatedAnnotation()).addSuperinterfaces(this.modelSuperInterfaces()).superclass(this.modelSuperClass()).addMethods(this.modelClassMethods()).addFields(fields).addFields(this.shapeModelSpec.staticFields(new Modifier[0])).addMethod(this.addModifier(this.sdkFieldsMethod(), Modifier.FINAL)).addTypes(this.nestedModelClassTypes());
        if (this.shapeModel.isUnion()) {
            specBuilder.addField(this.unionTypeField());
        }
        if (!this.isEvent()) {
            specBuilder.addModifiers(new Modifier[]{Modifier.FINAL});
        }
        if (this.shapeModel.getShapeType() == ShapeType.Model || this.shapeModel.getShapeType() == ShapeType.Exception) {
            specBuilder.addField(FieldSpec.builder(Long.TYPE, (String)"serialVersionUID", (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL}).initializer("1L", new Object[0]).build());
        }
        if (!fields.isEmpty()) {
            specBuilder.addMethod(this.getterCreator()).addMethod(this.setterCreator());
        }
        if (this.shapeModel.isEvent()) {
            this.addEventSupport(specBuilder);
        }
        if (this.shapeModel.getDocumentation() != null) {
            specBuilder.addJavadoc("$L", new Object[]{this.shapeModel.getDocumentation()});
        }
        return specBuilder.build();
    }

    private ModelBuilderSpecs resolveBuilderSpecs() {
        return new ModelBuilderSpecs(this.intermediateModel, this.shapeModel, this.typeProvider);
    }

    private TypeSpec eventStreamInterfaceSpec() {
        Collection<OperationModel> opModels = EventStreamUtils.findOperationsWithEventStream(this.intermediateModel, this.shapeModel);
        List<OperationModel> outputOperations = this.findOutputEventStreamOperations(opModels, this.shapeModel);
        EventStreamSpecHelper helper = new EventStreamSpecHelper(this.shapeModel, this.intermediateModel);
        ClassName modelClass = this.poetExtensions.getModelClassFromShape(this.shapeModel);
        TypeSpec.Builder builder = PoetUtils.createInterfaceBuilder(modelClass).addAnnotation(SdkPublicApi.class).addMethods(this.eventStreamInterfaceEventBuilderMethods()).addType(helper.eventTypeEnumSpec());
        ClassName eventTypeEnum = helper.eventTypeEnumClassName();
        builder.addMethod(MethodSpec.methodBuilder((String)"sdkEventType").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.DEFAULT}).returns((TypeName)eventTypeEnum).addJavadoc("The type of this event. Corresponds to the {@code :event-type} header on the Message.", new Object[0]).addStatement("return $T.UNKNOWN_TO_SDK_VERSION", new Object[]{eventTypeEnum}).build());
        if (!outputOperations.isEmpty()) {
            CodeBlock unknownInitializer = this.buildUnknownEventStreamInitializer(outputOperations, modelClass);
            builder.addSuperinterface((TypeName)ClassName.get(SdkPojo.class)).addJavadoc("Base interface for all event types in $L.", new Object[]{this.shapeModel.getShapeName()}).addField(FieldSpec.builder((TypeName)modelClass, (String)"UNKNOWN", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL}).initializer(unknownInitializer).addJavadoc("Special type of {@link $T} for unknown types of events that this version of the SDK does not know about", new Object[]{modelClass}).build());
            for (OperationModel opModel : outputOperations) {
                ClassName responseHandlerClass = this.poetExtensions.eventStreamResponseHandlerType(opModel);
                builder.addMethod(this.acceptMethodSpec(modelClass, responseHandlerClass).addModifiers(new Modifier[]{Modifier.ABSTRACT}).build());
            }
            return builder.build();
        }
        if (this.hasInputStreamOperations(opModels, this.shapeModel)) {
            return builder.addJavadoc("Base interface for all event types in $L.", new Object[]{this.shapeModel.getShapeName()}).build();
        }
        throw new IllegalArgumentException(this.shapeModel.getShapeName() + " event stream shape is not found in any request or response shape");
    }

    private void addEventSupport(TypeSpec.Builder specBuilder) {
        EventStreamUtils.getBaseEventStreamShapes(this.intermediateModel, this.shapeModel).forEach(eventStream -> this.addEventSupport(specBuilder, (ShapeModel)eventStream));
    }

    private void addEventSupport(TypeSpec.Builder specBuilder, ShapeModel eventStream) {
        ClassName eventStreamClassName = this.poetExtensions.getModelClassFromShape(eventStream);
        Collection<OperationModel> opModels = EventStreamUtils.findOperationsWithEventStream(this.intermediateModel, eventStream);
        List<OperationModel> outputOperations = this.findOutputEventStreamOperations(opModels, eventStream);
        boolean onOutput = !outputOperations.isEmpty();
        boolean onInput = this.hasInputStreamOperations(opModels, eventStream);
        if (!onOutput && !onInput) {
            throw new IllegalArgumentException(this.shapeModel.getC2jName() + " event shape is not a member in any request or response event shape");
        }
        EventStreamSpecHelper helper = new EventStreamSpecHelper(eventStream, this.intermediateModel);
        specBuilder.addSuperinterface((TypeName)eventStreamClassName);
        boolean usesLegacyScheme = this.useLegacyEventGenerationScheme(eventStream);
        Optional<MemberModel> legacyEvent = this.findLegacyGenerationEventWithShape(eventStream);
        if (usesLegacyScheme && legacyEvent.isPresent()) {
            NamingStrategy namingStrategy = this.intermediateModel.getNamingStrategy();
            ClassName eventTypeEnum = helper.eventTypeEnumClassName();
            specBuilder.addMethod(MethodSpec.methodBuilder((String)"sdkEventType").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)eventTypeEnum).addStatement("return $T.$N", new Object[]{eventTypeEnum, namingStrategy.getEnumValueName(legacyEvent.get().getName())}).build());
        }
        if (onOutput) {
            ClassName modelClass = this.poetExtensions.getModelClass(this.shapeModel.getShapeName());
            for (OperationModel opModel : outputOperations) {
                ClassName responseHandlerClass = this.poetExtensions.eventStreamResponseHandlerType(opModel);
                MethodSpec.Builder acceptMethodSpec = this.acceptMethodSpec(modelClass, responseHandlerClass).addAnnotation(Override.class);
                if (usesLegacyScheme) {
                    acceptMethodSpec.addStatement("visitor.visit(this)", new Object[0]);
                } else {
                    acceptMethodSpec.addStatement("throw new $T()", new Object[]{UnsupportedOperationException.class});
                }
                specBuilder.addMethod(acceptMethodSpec.build());
            }
        }
    }

    private boolean hasInputStreamOperations(Collection<OperationModel> opModels, ShapeModel eventStream) {
        return opModels.stream().anyMatch(op -> EventStreamUtils.doesShapeContainsEventStream(op.getInputShape(), eventStream));
    }

    private List<OperationModel> findOutputEventStreamOperations(Collection<OperationModel> opModels, ShapeModel eventStream) {
        return opModels.stream().filter(opModel -> EventStreamUtils.doesShapeContainsEventStream(opModel.getOutputShape(), eventStream)).collect(Collectors.toList());
    }

    private CodeBlock buildUnknownEventStreamInitializer(Collection<OperationModel> outputOperations, ClassName eventStreamModelClass) {
        CodeBlock.Builder builder = CodeBlock.builder().add("new $T() {\n        @Override\n        public $T<$T<?>> sdkFields() {\n            return $T.emptyList();\n        }\n", new Object[]{eventStreamModelClass, List.class, SdkField.class, Collections.class});
        for (OperationModel opModel : outputOperations) {
            ClassName responseHandlerClass = this.poetExtensions.eventStreamResponseHandlerType(opModel);
            builder.add("        @Override\n        public void accept($T.Visitor visitor) {            \nvisitor.visitDefault(this);\n        }\n", new Object[]{responseHandlerClass});
        }
        builder.add("    }\n", new Object[0]);
        return builder.build();
    }

    private MethodSpec sdkFieldsMethod() {
        ParameterizedTypeName sdkFieldType = ParameterizedTypeName.get((ClassName)ClassName.get(SdkField.class), (TypeName[])new TypeName[]{WildcardTypeName.subtypeOf((TypeName)ClassName.get(Object.class))});
        return MethodSpec.methodBuilder((String)"sdkFields").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).returns((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(List.class), (TypeName[])new TypeName[]{sdkFieldType})).addCode("return SDK_FIELDS;", new Object[0]).build();
    }

    private MethodSpec getterCreator() {
        TypeVariableName t = TypeVariableName.get((String)"T");
        return MethodSpec.methodBuilder((String)"getter").addTypeVariable(t).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.STATIC}).addParameter((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(Function.class), (TypeName[])new TypeName[]{this.className(), t}), "g", new Modifier[0]).returns((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(Function.class), (TypeName[])new TypeName[]{ClassName.get(Object.class), t})).addStatement("return obj -> g.apply(($T) obj)", new Object[]{this.className()}).build();
    }

    private MethodSpec setterCreator() {
        TypeVariableName t = TypeVariableName.get((String)"T");
        return MethodSpec.methodBuilder((String)"setter").addTypeVariable(t).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.STATIC}).addParameter((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(BiConsumer.class), (TypeName[])new TypeName[]{this.builderClassName(), t}), "s", new Modifier[0]).returns((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(BiConsumer.class), (TypeName[])new TypeName[]{ClassName.get(Object.class), t})).addStatement("return (obj, val) -> s.accept(($T) obj, val)", new Object[]{this.builderClassName()}).build();
    }

    private MethodSpec.Builder acceptMethodSpec(ClassName modelClass, ClassName responseHandlerClass) {
        return MethodSpec.methodBuilder((String)"accept").addModifiers(new Modifier[]{Modifier.PUBLIC}).addJavadoc(new DocumentationBuilder().description("Calls the appropriate visit method depending on the subtype of {@link $T}.").param("visitor", "Visitor to invoke.").build(), new Object[]{modelClass}).addParameter((TypeName)responseHandlerClass.nestedClass("Visitor"), "visitor", new Modifier[0]);
    }

    @Override
    public ClassName className() {
        return this.shapeModelSpec.className();
    }

    private ClassName builderClassName() {
        return this.className().nestedClass("Builder");
    }

    private ClassName unionTypeClassName() {
        return this.className().nestedClass("Type");
    }

    private List<TypeName> modelSuperInterfaces() {
        ArrayList<TypeName> interfaces = new ArrayList<TypeName>();
        switch (this.shapeModel.getShapeType()) {
            case Model: {
                interfaces.add((TypeName)ClassName.get(SdkPojo.class));
                interfaces.add((TypeName)ClassName.get(Serializable.class));
                interfaces.add(this.toCopyableBuilderInterface());
                break;
            }
            case Exception: 
            case Request: 
            case Response: {
                interfaces.add(this.toCopyableBuilderInterface());
                break;
            }
        }
        return interfaces;
    }

    private TypeName modelSuperClass() {
        switch (this.shapeModel.getShapeType()) {
            case Request: {
                return this.requestBaseClass();
            }
            case Response: {
                return this.responseBaseClass();
            }
            case Exception: {
                return this.exceptionBaseClass();
            }
        }
        return ClassName.OBJECT;
    }

    private TypeName requestBaseClass() {
        return new AwsServiceBaseRequestSpec(this.intermediateModel).className();
    }

    private TypeName responseBaseClass() {
        return new AwsServiceBaseResponseSpec(this.intermediateModel).className();
    }

    private ClassName exceptionBaseClass() {
        String customExceptionBase = this.intermediateModel.getCustomizationConfig().getSdkModeledExceptionBaseClassName();
        if (customExceptionBase != null) {
            return this.poetExtensions.getModelClass(customExceptionBase);
        }
        return this.poetExtensions.getModelClass(this.intermediateModel.getSdkModeledExceptionBaseClassName());
    }

    private TypeName toCopyableBuilderInterface() {
        return ParameterizedTypeName.get((ClassName)ClassName.get(ToCopyableBuilder.class), (TypeName[])new TypeName[]{this.className().nestedClass("Builder"), this.className()});
    }

    private List<MethodSpec> modelClassMethods() {
        ArrayList<MethodSpec> methodSpecs = new ArrayList<MethodSpec>();
        switch (this.shapeModel.getShapeType()) {
            case Exception: {
                methodSpecs.add(this.exceptionConstructor());
                methodSpecs.add(this.toBuilderMethod());
                methodSpecs.add(this.builderMethod());
                methodSpecs.add(this.serializableBuilderClass());
                methodSpecs.addAll(this.memberGetters());
                break;
            }
            default: {
                methodSpecs.addAll(this.addModifier(this.memberGetters(), Modifier.FINAL));
                methodSpecs.add(this.constructor());
                methodSpecs.add(this.toBuilderMethod());
                methodSpecs.add(this.builderMethod());
                methodSpecs.add(this.serializableBuilderClass());
                methodSpecs.add(this.addModifier(this.modelMethodOverrides.hashCodeMethod(this.shapeModel), Modifier.FINAL));
                methodSpecs.add(this.addModifier(this.modelMethodOverrides.equalsMethod(this.shapeModel), Modifier.FINAL));
                methodSpecs.add(this.addModifier(this.modelMethodOverrides.equalsBySdkFieldsMethod(this.shapeModel), Modifier.FINAL));
                methodSpecs.add(this.addModifier(this.modelMethodOverrides.toStringMethod(this.shapeModel), Modifier.FINAL));
                methodSpecs.add(this.getValueForField());
                methodSpecs.addAll(this.unionMembers());
            }
        }
        if (this.isEvent()) {
            methodSpecs.add(this.copyMethod());
        }
        return methodSpecs;
    }

    private MethodSpec getValueForField() {
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)"getValueForField").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addTypeVariable(TypeVariableName.get((String)"T")).returns((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(Optional.class), (TypeName[])new TypeName[]{TypeVariableName.get((String)"T")})).addParameter(String.class, "fieldName", new Modifier[0]).addParameter((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(Class.class), (TypeName[])new TypeName[]{TypeVariableName.get((String)"T")}), "clazz", new Modifier[0]);
        if (this.shapeModel.getNonStreamingMembers().isEmpty()) {
            methodBuilder.addStatement("return $T.empty()", new Object[]{Optional.class});
            return methodBuilder.build();
        }
        methodBuilder.beginControlFlow("switch ($L)", new Object[]{"fieldName"});
        this.shapeModel.getNonStreamingMembers().forEach(m -> this.addCasesForMember(methodBuilder, (MemberModel)m));
        methodBuilder.addCode("default:", new Object[0]);
        methodBuilder.addStatement("return $T.empty()", new Object[]{Optional.class});
        methodBuilder.endControlFlow();
        return methodBuilder.build();
    }

    private FieldSpec unionTypeField() {
        return FieldSpec.builder((TypeName)this.unionTypeClassName(), (String)"type", (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).build();
    }

    private Collection<MethodSpec> unionMembers() {
        if (!this.shapeModel.isUnion()) {
            return Collections.emptyList();
        }
        Validate.isFalse((boolean)this.shapeModel.isEvent(), (String)"Event shape %s must not be a union", (Object[])new Object[]{this.shapeModel.getShapeName()});
        Validate.isFalse((boolean)this.shapeModel.isEventStream(), (String)"Event stream shape %s must not be a union", (Object[])new Object[]{this.shapeModel.getShapeName()});
        Validate.isFalse((boolean)this.shapeModel.isDocument(), (String)"Document shape %s must not be a union", (Object[])new Object[]{this.shapeModel.getShapeName()});
        Validate.isFalse((this.isRequest() && this.isResponse() ? 1 : 0) != 0, (String)"Input or output shape %s must not be a union", (Object[])new Object[]{this.shapeModel.getShapeName()});
        ArrayList<MethodSpec> unionMembers = new ArrayList<MethodSpec>();
        unionMembers.addAll(this.unionConstructors());
        unionMembers.add(this.unionTypeMethod());
        unionMembers.addAll(this.unionAcceptMethods());
        return unionMembers;
    }

    private Collection<MethodSpec> unionConstructors() {
        return this.shapeModel.getMembers().stream().flatMap(this::unionConstructors).collect(Collectors.toList());
    }

    private Stream<MethodSpec> unionConstructors(MemberModel member) {
        ArrayList<MethodSpec> unionConstructors = new ArrayList<MethodSpec>();
        String memberName = member.getFluentSetterMethodName();
        String methodName = "from" + Utils.capitalize(memberName);
        unionConstructors.add(MethodSpec.methodBuilder((String)methodName).addJavadoc("$L", new Object[]{member.getUnionConstructorDocumentation()}).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).returns((TypeName)this.className()).addParameter(this.typeProvider.typeName(member, new TypeProvider.TypeNameOptions().useEnumTypes(false)), memberName, new Modifier[0]).addCode(CodeBlock.of((String)("return builder()." + memberName + "(" + memberName + ").build();"), (Object[])new Object[0])).build());
        if (member.getFluentEnumSetterMethodName() != null) {
            unionConstructors.add(MethodSpec.methodBuilder((String)("from" + Utils.capitalize(member.getFluentEnumSetterMethodName()))).addJavadoc("$L", new Object[]{member.getUnionConstructorDocumentation()}).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).returns((TypeName)this.className()).addParameter(this.typeProvider.typeName(member, new TypeProvider.TypeNameOptions().useEnumTypes(true)), memberName, new Modifier[0]).addCode(CodeBlock.of((String)("return builder()." + member.getFluentEnumSetterMethodName() + "(" + memberName + ").build();"), (Object[])new Object[0])).build());
        }
        if (!(member.isSimple() || member.isList() || member.isMap())) {
            TypeName memberType = this.typeProvider.typeName(member);
            ClassName memberClass = (ClassName)Validate.isInstanceOf(ClassName.class, (Object)memberType, (String)"Non-simple TypeName was not represented as a ClassName: %s", (Object[])new Object[]{memberType});
            ClassName memberClassBuilder = memberClass.nestedClass("Builder");
            unionConstructors.add(MethodSpec.methodBuilder((String)methodName).addJavadoc("$L", new Object[]{member.getUnionConstructorDocumentation()}).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).returns((TypeName)this.className()).addParameter((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(Consumer.class), (TypeName[])new TypeName[]{memberClassBuilder}), memberName, new Modifier[0]).addCode(CodeBlock.builder().add("$T builder = $T.builder();", new Object[]{memberClassBuilder, memberClass}).add("$L.accept(builder);", new Object[]{memberName}).add("return $L(builder.build());", new Object[]{methodName}).build()).build());
        }
        return unionConstructors.stream();
    }

    private MethodSpec unionTypeMethod() {
        return MethodSpec.methodBuilder((String)"type").addJavadoc("$L", new Object[]{this.shapeModel.getUnionTypeGetterDocumentation()}).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)this.unionTypeClassName()).addCode("return type;", new Object[0]).build();
    }

    private Collection<MethodSpec> unionAcceptMethods() {
        return Collections.emptyList();
    }

    private void addCasesForMember(MethodSpec.Builder methodBuilder, MemberModel member) {
        methodBuilder.addCode("case $S:", new Object[]{member.getC2jName()}).addStatement("return $T.ofNullable(clazz.cast($L()))", new Object[]{Optional.class, member.getFluentGetterMethodName()});
        if (this.shouldGenerateDeprecatedNameGetter(member)) {
            methodBuilder.addCode("case $S:", new Object[]{member.getDeprecatedName()}).addStatement("return $T.ofNullable(clazz.cast($L()))", new Object[]{Optional.class, member.getFluentGetterMethodName()});
        }
    }

    private List<MethodSpec> memberGetters() {
        return this.shapeModel.getNonStreamingMembers().stream().filter(m -> !m.getHttp().getIsStreaming()).flatMap(this::memberGetters).collect(Collectors.toList());
    }

    private Stream<MethodSpec> memberGetters(MemberModel member) {
        ArrayList<MethodSpec> result = new ArrayList<MethodSpec>();
        if (this.shouldGenerateEnumGetter(member)) {
            result.add(this.enumMemberGetter(member));
        }
        member.getAutoConstructClassIfExists().ifPresent(autoConstructClass -> result.add(this.existenceCheckGetter(member, (ClassName)autoConstructClass)));
        if (this.shouldGenerateDeprecatedNameGetter(member)) {
            result.add(this.deprecatedMemberGetter(member));
        }
        result.add(this.memberGetter(member));
        return DeprecationUtils.checkDeprecated(member, result).stream();
    }

    private boolean shouldGenerateDeprecatedNameGetter(MemberModel member) {
        return StringUtils.isNotBlank((CharSequence)member.getDeprecatedName());
    }

    private boolean shouldGenerateEnumGetter(MemberModel member) {
        return member.getEnumType() != null || MemberCopierSpec.isEnumCopyAvailable(member);
    }

    private MethodSpec enumMemberGetter(MemberModel member) {
        return MethodSpec.methodBuilder((String)member.getFluentEnumGetterMethodName()).addJavadoc("$L", new Object[]{member.getGetterDocumentation()}).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(this.typeProvider.enumReturnType(member)).addCode(this.enumGetterStatement(member)).build();
    }

    private MethodSpec memberGetter(MemberModel member) {
        return MethodSpec.methodBuilder((String)member.getFluentGetterMethodName()).addJavadoc("$L", new Object[]{member.getGetterDocumentation()}).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(this.typeProvider.returnType(member)).addCode(this.getterStatement(member)).build();
    }

    private MethodSpec existenceCheckGetter(MemberModel member, ClassName autoConstructClass) {
        return MethodSpec.methodBuilder((String)member.getExistenceCheckMethodName()).addJavadoc("$L", new Object[]{member.getExistenceCheckDocumentation()}).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(TypeName.BOOLEAN).addCode(this.existenceCheckStatement(member, autoConstructClass)).build();
    }

    private CodeBlock existenceCheckStatement(MemberModel member, ClassName autoConstructClass) {
        String variableName = member.getVariable().getVariableName();
        return CodeBlock.of((String)"return $N != null && !($N instanceof $T);", (Object[])new Object[]{variableName, variableName, autoConstructClass});
    }

    private MethodSpec deprecatedMemberGetter(MemberModel member) {
        return MethodSpec.methodBuilder((String)member.getDeprecatedFluentGetterMethodName()).addJavadoc("$L", new Object[]{member.getDeprecatedGetterDocumentation()}).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Deprecated.class).returns(this.typeProvider.returnType(member)).addCode(this.getterStatement(member)).build();
    }

    private CodeBlock enumGetterStatement(MemberModel member) {
        String fieldName = member.getVariable().getVariableName();
        if (member.isList() || member.isMap()) {
            Optional<ClassName> copier = this.serviceModelCopiers.copierClassFor(member);
            if (!copier.isPresent()) {
                throw new IllegalStateException("Don't know how to copy " + fieldName + " with enum elements!");
            }
            return CodeBlock.of((String)"return $T.$N($N);", (Object[])new Object[]{copier.get(), this.serviceModelCopiers.stringToEnumCopyMethodName(), fieldName});
        }
        ClassName enumClass = this.poetExtensions.getModelClass(member.getEnumType());
        return CodeBlock.of((String)"return $T.fromValue($N);", (Object[])new Object[]{enumClass, fieldName});
    }

    private CodeBlock getterStatement(MemberModel model) {
        VariableModel modelVariable = model.getVariable();
        return CodeBlock.of((String)"return $N;", (Object[])new Object[]{modelVariable.getVariableName()});
    }

    private List<TypeSpec> nestedModelClassTypes() {
        ArrayList<TypeSpec> nestedClasses = new ArrayList<TypeSpec>();
        switch (this.shapeModel.getShapeType()) {
            case Model: 
            case Exception: 
            case Request: 
            case Response: {
                nestedClasses.add(this.modelBuilderSpecs.builderInterface());
                nestedClasses.add(this.modelBuilderSpecs.beanStyleBuilder());
                break;
            }
        }
        if (this.shapeModel.isUnion()) {
            nestedClasses.add(this.modelBuilderSpecs.unionTypeClass());
        }
        return nestedClasses;
    }

    private MethodSpec constructor() {
        MethodSpec.Builder ctorBuilder = MethodSpec.constructorBuilder().addParameter((TypeName)this.modelBuilderSpecs.builderImplName(), "builder", new Modifier[0]);
        if (this.shapeModel.isEvent()) {
            ctorBuilder.addModifiers(new Modifier[]{Modifier.PROTECTED});
        } else {
            ctorBuilder.addModifiers(new Modifier[]{Modifier.PRIVATE});
        }
        if (this.isRequest() || this.isResponse()) {
            ctorBuilder.addStatement("super(builder)", new Object[0]);
        }
        this.shapeModelSpec.fields().forEach(f -> ctorBuilder.addStatement("this.$N = builder.$N", new Object[]{f, f}));
        if (this.shapeModel.isUnion()) {
            ctorBuilder.addStatement("this.type = builder.type", new Object[0]);
        }
        return ctorBuilder.build();
    }

    private MethodSpec exceptionConstructor() {
        MethodSpec.Builder ctorBuilder = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PRIVATE}).addParameter((TypeName)this.modelBuilderSpecs.builderImplName(), "builder", new Modifier[0]);
        ctorBuilder.addStatement("super(builder)", new Object[0]);
        this.shapeModelSpec.fields().forEach(f -> ctorBuilder.addStatement("this.$N = builder.$N", new Object[]{f, f}));
        return ctorBuilder.build();
    }

    private MethodSpec builderMethod() {
        return MethodSpec.methodBuilder((String)"builder").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).returns((TypeName)this.modelBuilderSpecs.builderInterfaceName()).addStatement("return new $T()", new Object[]{this.modelBuilderSpecs.builderImplName()}).build();
    }

    private MethodSpec toBuilderMethod() {
        return MethodSpec.methodBuilder((String)"toBuilder").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).returns((TypeName)this.modelBuilderSpecs.builderInterfaceName()).addStatement("return new $T(this)", new Object[]{this.modelBuilderSpecs.builderImplName()}).build();
    }

    private MethodSpec serializableBuilderClass() {
        return MethodSpec.methodBuilder((String)"serializableBuilderClass").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).returns((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(Class.class), (TypeName[])new TypeName[]{WildcardTypeName.subtypeOf((TypeName)this.modelBuilderSpecs.builderInterfaceName())})).addStatement("return $T.class", new Object[]{this.modelBuilderSpecs.builderImplName()}).build();
    }

    private MethodSpec copyMethod() {
        ParameterizedTypeName consumerParam = ParameterizedTypeName.get((ClassName)ClassName.get(Consumer.class), (TypeName[])new TypeName[]{WildcardTypeName.supertypeOf((TypeName)this.modelBuilderSpecs.builderInterfaceName())});
        return MethodSpec.methodBuilder((String)"copy").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addAnnotation(Override.class).addParameter((TypeName)consumerParam, "modifier", new Modifier[0]).addStatement("return $T.super.copy(modifier)", new Object[]{ToCopyableBuilder.class}).returns((TypeName)this.className()).build();
    }

    private boolean isResponse() {
        return this.shapeModel.getShapeType() == ShapeType.Response;
    }

    private boolean isRequest() {
        return this.shapeModel.getShapeType() == ShapeType.Request;
    }

    private boolean isEvent() {
        return this.shapeModel.isEvent();
    }

    private List<MethodSpec> eventStreamInterfaceEventBuilderMethods() {
        return this.shapeModel.getMembers().stream().filter(m -> m.getShape().isEvent()).map(this::eventBuilderMethod).collect(Collectors.toList());
    }

    private MethodSpec eventBuilderMethod(MemberModel event) {
        ClassName returnType;
        EventStreamSpecHelper specHelper = new EventStreamSpecHelper(this.shapeModel, this.intermediateModel);
        ClassName eventClassName = specHelper.eventClassName(event);
        if (specHelper.useLegacyGenerationScheme(event)) {
            returnType = eventClassName.nestedClass("Builder");
        } else {
            ClassName baseClass = this.poetExtensions.getModelClass(event.getShape().getShapeName());
            returnType = baseClass.nestedClass("Builder");
        }
        String methodName = specHelper.eventBuilderMethodName(event);
        return MethodSpec.methodBuilder((String)methodName).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).returns((TypeName)returnType).addJavadoc("Create a builder for the {@code $L} event type for this stream.", new Object[]{event.getC2jName()}).addStatement("return $T.builder()", new Object[]{eventClassName}).build();
    }

    private List<MethodSpec> addModifier(List<MethodSpec> specs, Modifier modifier) {
        return specs.stream().map(spec -> this.addModifier((MethodSpec)spec, modifier)).collect(Collectors.toList());
    }

    private MethodSpec addModifier(MethodSpec spec, Modifier modifier) {
        return spec.toBuilder().addModifiers(new Modifier[]{modifier}).build();
    }

    private boolean useLegacyEventGenerationScheme(ShapeModel eventStream) {
        EventStreamSpecHelper helper = new EventStreamSpecHelper(eventStream, this.intermediateModel);
        for (MemberModel member : eventStream.getMembers()) {
            if (!member.getShape().equals(this.shapeModel) || !helper.useLegacyGenerationScheme(member)) continue;
            return true;
        }
        return false;
    }

    private Optional<MemberModel> findLegacyGenerationEventWithShape(ShapeModel eventStream) {
        EventStreamSpecHelper helper = new EventStreamSpecHelper(eventStream, this.intermediateModel);
        for (MemberModel member : eventStream.getMembers()) {
            if (!member.getShape().equals(this.shapeModel) || !helper.useLegacyGenerationScheme(member)) continue;
            return Optional.ofNullable(member);
        }
        return Optional.empty();
    }
}

