/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.emitters.tasks;

import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import software.amazon.awssdk.codegen.emitters.GeneratorTask;
import software.amazon.awssdk.codegen.emitters.GeneratorTaskParams;
import software.amazon.awssdk.codegen.emitters.SimpleGeneratorTask;
import software.amazon.awssdk.codegen.emitters.tasks.BaseGeneratorTasks;
import software.amazon.awssdk.utils.IoUtils;
import software.amazon.awssdk.utils.StringUtils;
import software.amazon.awssdk.utils.Validate;

public final class RulesEngineRuntimeGeneratorTask
extends BaseGeneratorTasks {
    public static final String RUNTIME_CLASS_NAME = "WaitersRuntime";
    private final String engineInternalClassDir;
    private final String engineInternalResourcesDir;
    private final String engineInternalPackageName;
    private final String fileHeader;

    public RulesEngineRuntimeGeneratorTask(GeneratorTaskParams generatorTaskParams) {
        super(generatorTaskParams);
        this.engineInternalClassDir = generatorTaskParams.getPathProvider().getEndpointRulesInternalDirectory();
        this.engineInternalResourcesDir = generatorTaskParams.getPathProvider().getEndpointRulesInternalResourcesDirectory();
        this.engineInternalPackageName = generatorTaskParams.getModel().getMetadata().getFullInternalEndpointRulesPackageName();
        this.fileHeader = generatorTaskParams.getModel().getFileHeader();
    }

    @Override
    protected List<GeneratorTask> createTasks() throws Exception {
        String newFileName;
        ArrayList<GeneratorTask> copyTasks = new ArrayList<GeneratorTask>();
        List<String> rulesEngineFiles = this.rulesEngineResourceFiles();
        for (String path : this.rulesEngineJavaFilePaths(rulesEngineFiles)) {
            newFileName = this.computeNewName(path);
            copyTasks.add(new SimpleGeneratorTask(this.engineInternalClassDir, newFileName, this.fileHeader, () -> this.rulesEngineFileContent("/" + path)));
        }
        for (String path : this.rulesEngineJsonFilePaths(rulesEngineFiles)) {
            newFileName = this.computeNewName(path);
            copyTasks.add(new SimpleGeneratorTask(this.engineInternalResourcesDir, newFileName, ".json", "", () -> this.loadResourceAsString("/" + path)));
        }
        return copyTasks;
    }

    private List<String> rulesEngineJavaFilePaths(Collection<String> runtimeEngineFiles) {
        return runtimeEngineFiles.stream().filter(e -> e.endsWith(".java.resource")).collect(Collectors.toList());
    }

    private List<String> rulesEngineJsonFilePaths(Collection<String> runtimeEngineFiles) {
        return runtimeEngineFiles.stream().filter(e -> e.endsWith(".json.resource")).collect(Collectors.toList());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<String> rulesEngineResourceFiles() {
        URL currentJarUrl = RulesEngineRuntimeGeneratorTask.class.getProtectionDomain().getCodeSource().getLocation();
        try (JarFile jarFile = new JarFile(currentJarUrl.getFile());){
            List<String> list = jarFile.stream().map(ZipEntry::getName).filter(e -> e.startsWith("software/amazon/awssdk/codegen/rules")).collect(Collectors.toList());
            return list;
        }
        catch (IOException e2) {
            throw new UncheckedIOException(e2);
        }
    }

    private String rulesEngineFileContent(String path) {
        return "package " + this.engineInternalPackageName + ";\n\n" + this.loadResourceAsString(path);
    }

    private String loadResourceAsString(String path) {
        try {
            return IoUtils.toUtf8String((InputStream)this.loadResource(path));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private InputStream loadResource(String name) {
        InputStream resourceAsStream = RulesEngineRuntimeGeneratorTask.class.getResourceAsStream(name);
        Validate.notNull((Object)resourceAsStream, (String)"Failed to load resource from %s", (Object[])new Object[]{name});
        return resourceAsStream;
    }

    private String computeNewName(String path) {
        String[] pathComponents = path.split("/");
        return StringUtils.replace((String)pathComponents[pathComponents.length - 1], (String)".resource", (String)"");
    }
}

