/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.lite.defaultsmode;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.Modifier;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.codegen.lite.PoetClass;
import software.amazon.awssdk.codegen.lite.defaultsmode.DefaultConfiguration;
import software.amazon.awssdk.utils.AttributeMap;

public class DefaultsModeConfigurationGenerator
implements PoetClass {
    private static final String DEFAULT_CONFIG_BY_MODE_ENUM_MAP = "DEFAULT_CONFIG_BY_MODE";
    private static final String DEFAULT_HTTP_CONFIG_BY_MODE_ENUM_MAP = "DEFAULT_HTTP_CONFIG_BY_MODE";
    private static final String DEFAULTS_VAR_SUFFIX = "_DEFAULTS";
    private static final String HTTP_DEFAULTS_VAR_SUFFIX = "_HTTP_DEFAULTS";
    private static final Map<String, OptionMetadata> CONFIGURATION_MAPPING = new HashMap<String, OptionMetadata>();
    private static final Map<String, OptionMetadata> HTTP_CONFIGURATION_MAPPING = new HashMap<String, OptionMetadata>();
    private static final String CONNECT_TIMEOUT_IN_MILLIS = "connectTimeoutInMillis";
    private static final String TLS_NEGOTIATION_TIMEOUT_IN_MILLIS = "tlsNegotiationTimeoutInMillis";
    private static final String S3_US_EAST_1_REGIONAL_ENDPOINTS = "s3UsEast1RegionalEndpoints";
    private final String basePackage;
    private final String defaultsModeBase;
    private final DefaultConfiguration configuration;

    public DefaultsModeConfigurationGenerator(String basePackage, String defaultsModeBase, DefaultConfiguration configuration) {
        this.basePackage = basePackage;
        this.configuration = configuration;
        this.defaultsModeBase = defaultsModeBase;
    }

    @Override
    public TypeSpec poetClass() {
        TypeSpec.Builder builder = TypeSpec.classBuilder((ClassName)this.className()).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addJavadoc(this.documentation()).addAnnotation(SdkInternalApi.class).addAnnotation(AnnotationSpec.builder(Generated.class).addMember("value", "$S", new Object[]{"software.amazon.awssdk:codegen"}).build()).addMethod(this.defaultConfigMethod(DEFAULT_CONFIG_BY_MODE_ENUM_MAP, "defaultConfig")).addMethod(this.defaultConfigMethod(DEFAULT_HTTP_CONFIG_BY_MODE_ENUM_MAP, "defaultHttpConfig")).addMethod(this.createConstructor());
        this.configuration.modeDefaults().entrySet().forEach(entry -> {
            builder.addField(this.addDefaultsFieldForMode((Map.Entry<String, Map<String, String>>)entry));
            builder.addField(this.addHttpDefaultsFieldForMode((Map.Entry<String, Map<String, String>>)entry));
        });
        this.addDefaultsFieldForLegacy(builder, "LEGACY_DEFAULTS");
        this.addDefaultsFieldForLegacy(builder, "LEGACY_HTTP_DEFAULTS");
        this.addEnumMapField(builder, DEFAULT_CONFIG_BY_MODE_ENUM_MAP);
        this.addEnumMapField(builder, DEFAULT_HTTP_CONFIG_BY_MODE_ENUM_MAP);
        this.addStaticEnumMapBlock(builder);
        return builder.build();
    }

    private void addStaticEnumMapBlock(TypeSpec.Builder builder) {
        CodeBlock.Builder staticCodeBlock = CodeBlock.builder();
        this.putItemsToEnumMap(staticCodeBlock, this.configuration.modeDefaults().keySet(), DEFAULTS_VAR_SUFFIX, DEFAULT_CONFIG_BY_MODE_ENUM_MAP);
        this.putItemsToEnumMap(staticCodeBlock, this.configuration.modeDefaults().keySet(), HTTP_DEFAULTS_VAR_SUFFIX, DEFAULT_HTTP_CONFIG_BY_MODE_ENUM_MAP);
        builder.addStaticBlock(staticCodeBlock.build());
    }

    private void addEnumMapField(TypeSpec.Builder builder, String name) {
        ParameterizedTypeName map = ParameterizedTypeName.get((ClassName)ClassName.get(Map.class), (TypeName[])new TypeName[]{this.defaultsModeClassName(), ClassName.get(AttributeMap.class)});
        FieldSpec field = FieldSpec.builder((TypeName)map, (String)name, (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL}).initializer("new $T<>(DefaultsMode.class)", new Object[]{EnumMap.class}).build();
        builder.addField(field);
    }

    private void putItemsToEnumMap(CodeBlock.Builder codeBlock, Set<String> modes, String suffix, String mapName) {
        modes.forEach(m -> {
            String mode = this.sanitizeMode((String)m);
            codeBlock.addStatement("$N.put(DefaultsMode.$N, $N)", new Object[]{mapName, mode, mode + suffix});
        });
        codeBlock.addStatement("$N.put(DefaultsMode.LEGACY, LEGACY$N)", new Object[]{mapName, suffix});
    }

    @Override
    public ClassName className() {
        return ClassName.get((String)this.basePackage, (String)"DefaultsModeConfiguration", (String[])new String[0]);
    }

    private FieldSpec addDefaultsFieldForMode(Map.Entry<String, Map<String, String>> modeEntry) {
        String mode = modeEntry.getKey();
        String fieldName = this.sanitizeMode(mode) + DEFAULTS_VAR_SUFFIX;
        CodeBlock.Builder attributeBuilder = CodeBlock.builder().add("$T.builder()", new Object[]{AttributeMap.class});
        modeEntry.getValue().entrySet().stream().filter(e -> CONFIGURATION_MAPPING.containsKey(e.getKey())).forEach(e -> this.attributeMapBuilder((String)e.getKey(), (String)e.getValue(), attributeBuilder));
        FieldSpec.Builder fieldSpec = FieldSpec.builder(AttributeMap.class, (String)fieldName, (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL}).initializer(attributeBuilder.add(".build()", new Object[0]).build());
        return fieldSpec.build();
    }

    private void addDefaultsFieldForLegacy(TypeSpec.Builder builder, String name) {
        FieldSpec field = FieldSpec.builder(AttributeMap.class, (String)name, (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL}).initializer("$T.empty()", new Object[]{AttributeMap.class}).build();
        builder.addField(field);
    }

    private void attributeMapBuilder(String option, String value, CodeBlock.Builder attributeBuilder) {
        OptionMetadata optionMetadata = CONFIGURATION_MAPPING.get(option);
        switch (option) {
            case "retryMode": {
                attributeBuilder.add(".put($T, $T.$N)", new Object[]{optionMetadata.attribute, optionMetadata.type, value.toUpperCase(Locale.US)});
                break;
            }
            case "s3UsEast1RegionalEndpoints": {
                attributeBuilder.add(".put($T, $S)", new Object[]{optionMetadata.attribute, value});
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported option " + option);
            }
        }
    }

    private void httpAttributeMapBuilder(String option, String value, CodeBlock.Builder attributeBuilder) {
        OptionMetadata optionMetadata = HTTP_CONFIGURATION_MAPPING.get(option);
        switch (option) {
            case "connectTimeoutInMillis": 
            case "tlsNegotiationTimeoutInMillis": {
                attributeBuilder.add(".put($T, $T.ofMillis($N))", new Object[]{optionMetadata.attribute, optionMetadata.type, value});
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported option " + option);
            }
        }
    }

    private FieldSpec addHttpDefaultsFieldForMode(Map.Entry<String, Map<String, String>> modeEntry) {
        String mode = modeEntry.getKey();
        String fieldName = this.sanitizeMode(mode) + HTTP_DEFAULTS_VAR_SUFFIX;
        CodeBlock.Builder attributeBuilder = CodeBlock.builder().add("$T.builder()", new Object[]{AttributeMap.class});
        modeEntry.getValue().entrySet().stream().filter(e -> HTTP_CONFIGURATION_MAPPING.containsKey(e.getKey())).forEach(e -> this.httpAttributeMapBuilder((String)e.getKey(), (String)e.getValue(), attributeBuilder));
        FieldSpec.Builder fieldSpec = FieldSpec.builder(AttributeMap.class, (String)fieldName, (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL}).initializer(attributeBuilder.add(".build()", new Object[0]).build());
        return fieldSpec.build();
    }

    private String sanitizeMode(String str) {
        return str.replace('-', '_').toUpperCase(Locale.US);
    }

    private CodeBlock documentation() {
        CodeBlock.Builder builder = CodeBlock.builder().add("Contains a collection of default configuration options for each DefaultsMode", new Object[0]);
        return builder.build();
    }

    private MethodSpec defaultConfigMethod(String enumMap, String methodName) {
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)methodName).returns(AttributeMap.class).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).addJavadoc("Return the default config options for a given defaults mode", new Object[0]).addParameter((TypeName)this.defaultsModeClassName(), "mode", new Modifier[0]).addStatement("return $N.getOrDefault(mode, $T.empty())", new Object[]{enumMap, AttributeMap.class});
        return methodBuilder.build();
    }

    private ClassName defaultsModeClassName() {
        return ClassName.get((String)this.defaultsModeBase, (String)"DefaultsMode", (String[])new String[0]);
    }

    private MethodSpec createConstructor() {
        return MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PRIVATE}).build();
    }

    static {
        HTTP_CONFIGURATION_MAPPING.put(CONNECT_TIMEOUT_IN_MILLIS, new OptionMetadata(ClassName.get((String)"java.time", (String)"Duration", (String[])new String[0]), ClassName.get((String)"software.amazon.awssdk.http", (String)"SdkHttpConfigurationOption", (String[])new String[]{"CONNECTION_TIMEOUT"})));
        HTTP_CONFIGURATION_MAPPING.put(TLS_NEGOTIATION_TIMEOUT_IN_MILLIS, new OptionMetadata(ClassName.get((String)"java.time", (String)"Duration", (String[])new String[0]), ClassName.get((String)"software.amazon.awssdk.http", (String)"SdkHttpConfigurationOption", (String[])new String[]{"TLS_NEGOTIATION_TIMEOUT"})));
        CONFIGURATION_MAPPING.put("retryMode", new OptionMetadata(ClassName.get((String)"software.amazon.awssdk.core.retry", (String)"RetryMode", (String[])new String[0]), ClassName.get((String)"software.amazon.awssdk.core.client.config", (String)"SdkClientOption", (String[])new String[]{"DEFAULT_RETRY_MODE"})));
        CONFIGURATION_MAPPING.put(S3_US_EAST_1_REGIONAL_ENDPOINTS, new OptionMetadata(ClassName.get(String.class), ClassName.get((String)"software.amazon.awssdk.regions", (String)"ServiceMetadataAdvancedOption", (String[])new String[]{"DEFAULT_S3_US_EAST_1_REGIONAL_ENDPOINT"})));
    }

    private static final class OptionMetadata {
        private final ClassName type;
        private final ClassName attribute;

        OptionMetadata(ClassName type, ClassName attribute) {
            this.type = type;
            this.attribute = attribute;
        }
    }
}

