/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.lite.regions;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.lang.model.element.Modifier;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.codegen.lite.PoetClass;
import software.amazon.awssdk.codegen.lite.regions.model.Endpoint;
import software.amazon.awssdk.codegen.lite.regions.model.Partition;
import software.amazon.awssdk.codegen.lite.regions.model.Partitions;
import software.amazon.awssdk.codegen.lite.regions.model.Service;
import software.amazon.awssdk.utils.StringUtils;
import software.amazon.awssdk.utils.internal.CodegenNamingUtils;

public class EndpointTagGenerator
implements PoetClass {
    private final Partitions partitions;
    private final String basePackage;

    public EndpointTagGenerator(Partitions partitions, String basePackage) {
        this.partitions = partitions;
        this.basePackage = basePackage;
    }

    @Override
    public TypeSpec poetClass() {
        TypeSpec.Builder builder = TypeSpec.classBuilder((ClassName)this.className()).addModifiers(new Modifier[]{Modifier.FINAL, Modifier.PUBLIC}).addJavadoc(this.documentation()).addAnnotation(SdkPublicApi.class).addAnnotation(AnnotationSpec.builder(Generated.class).addMember("value", "$S", new Object[]{"software.amazon.awssdk:codegen"}).build()).addMethod(MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PRIVATE}).addParameter(String.class, "id", new Modifier[0]).addStatement("this.id = id", new Object[0]).build());
        this.endpointTags(builder);
        builder.addField(FieldSpec.builder(String.class, (String)"id", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.FINAL, Modifier.PRIVATE}).build()).addMethod(this.tagOf()).addMethod(this.tagGetter()).addMethod(this.id()).addMethod(this.tagToString());
        return builder.addType(this.cache()).build();
    }

    private void endpointTags(TypeSpec.Builder builder) {
        Stream<Endpoint> endpointsFromPartitions = this.partitions.getPartitions().stream().map(Partition::getDefaults);
        Stream endpointsFromServices = this.partitions.getPartitions().stream().flatMap(p -> p.getServices().values().stream()).flatMap(s -> s.getEndpoints().values().stream());
        Stream<Endpoint> endpointsFromServiceDefaults = this.partitions.getPartitions().stream().flatMap(p -> p.getServices().values().stream()).map(Service::getDefaults).filter(Objects::nonNull);
        Set allTags = Stream.concat(endpointsFromPartitions, Stream.concat(endpointsFromServices, endpointsFromServiceDefaults)).flatMap(e -> e.getVariants().stream()).flatMap(v -> v.getTags().stream()).collect(Collectors.toCollection(TreeSet::new));
        allTags.forEach(tag -> builder.addField(FieldSpec.builder((TypeName)this.className(), (String)this.enumValueForTagId((String)tag), (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL}).initializer("$T.of($S)", new Object[]{this.className(), tag}).build()));
        String tagsCodeBlock = allTags.stream().map(this::enumValueForTagId).collect(Collectors.joining(", "));
        CodeBlock initializer = CodeBlock.builder().add("$T.unmodifiableList($T.asList(", new Object[]{Collections.class, Arrays.class}).add(tagsCodeBlock, new Object[0]).add("))", new Object[0]).build();
        ParameterizedTypeName listOfTags = ParameterizedTypeName.get((ClassName)ClassName.get(List.class), (TypeName[])new TypeName[]{this.className()});
        builder.addField(FieldSpec.builder((TypeName)listOfTags, (String)"ENDPOINT_TAGS", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL}).initializer(initializer).build());
    }

    private String enumValueForTagId(String tag) {
        return Stream.of(CodegenNamingUtils.splitOnWordBoundaries((String)tag)).map(StringUtils::upperCase).collect(Collectors.joining("_"));
    }

    private MethodSpec tagOf() {
        return MethodSpec.methodBuilder((String)"of").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).addParameter(String.class, "id", new Modifier[0]).returns((TypeName)this.className()).addStatement("return EndpointTagCache.put($L)", new Object[]{"id"}).build();
    }

    private MethodSpec id() {
        return MethodSpec.methodBuilder((String)"id").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(String.class).addStatement("return this.id", new Object[0]).build();
    }

    private MethodSpec tagGetter() {
        return MethodSpec.methodBuilder((String)"endpointTags").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).returns((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(List.class), (TypeName[])new TypeName[]{this.className()})).addStatement("return $L", new Object[]{"ENDPOINT_TAGS"}).build();
    }

    private MethodSpec tagToString() {
        return MethodSpec.methodBuilder((String)"toString").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(String.class).addStatement("return $L", new Object[]{"id"}).build();
    }

    private TypeSpec cache() {
        ParameterizedTypeName mapOfStringTags = ParameterizedTypeName.get((ClassName)ClassName.get(ConcurrentHashMap.class), (TypeName[])new TypeName[]{ClassName.get(String.class), this.className()});
        return TypeSpec.classBuilder((String)"EndpointTagCache").addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.STATIC}).addField(FieldSpec.builder((TypeName)mapOfStringTags, (String)"IDS", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL}).initializer("new $T<>()", new Object[]{ConcurrentHashMap.class}).build()).addMethod(MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PRIVATE}).build()).addMethod(MethodSpec.methodBuilder((String)"put").addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.STATIC}).addParameter(String.class, "id", new Modifier[0]).returns((TypeName)this.className()).addStatement("return $L.computeIfAbsent(id, $T::new)", new Object[]{"IDS", this.className()}).build()).build();
    }

    private CodeBlock documentation() {
        return CodeBlock.builder().add("A tag applied to endpoints to specify that they're to be used in certain contexts. For example, FIPS tags are applied to endpoints discussed here: https://aws.amazon.com/compliance/fips/ and DUALSTACK tags are applied to endpoints that can return IPv6 addresses.", new Object[0]).build();
    }

    @Override
    public ClassName className() {
        return ClassName.get((String)this.basePackage, (String)"EndpointTag", (String[])new String[0]);
    }
}

