/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.codedeploy.CodeDeployClient;
import software.amazon.awssdk.services.codedeploy.internal.UserAgentUtils;
import software.amazon.awssdk.services.codedeploy.model.ListDeploymentConfigsRequest;
import software.amazon.awssdk.services.codedeploy.model.ListDeploymentConfigsResponse;

public class ListDeploymentConfigsIterable
implements SdkIterable<ListDeploymentConfigsResponse> {
    private final CodeDeployClient client;
    private final ListDeploymentConfigsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListDeploymentConfigsIterable(CodeDeployClient client, ListDeploymentConfigsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListDeploymentConfigsResponseFetcher();
    }

    public Iterator<ListDeploymentConfigsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<String> deploymentConfigsList() {
        Function<ListDeploymentConfigsResponse, Iterator> getIterator = response -> {
            if (response != null && response.deploymentConfigsList() != null) {
                return response.deploymentConfigsList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListDeploymentConfigsResponseFetcher
    implements SyncPageFetcher<ListDeploymentConfigsResponse> {
        private ListDeploymentConfigsResponseFetcher() {
        }

        public boolean hasNextPage(ListDeploymentConfigsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListDeploymentConfigsResponse nextPage(ListDeploymentConfigsResponse previousPage) {
            if (previousPage == null) {
                return ListDeploymentConfigsIterable.this.client.listDeploymentConfigs(ListDeploymentConfigsIterable.this.firstRequest);
            }
            return ListDeploymentConfigsIterable.this.client.listDeploymentConfigs((ListDeploymentConfigsRequest)((Object)ListDeploymentConfigsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

