/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum DeploymentCreator {
    USER("user"),
    AUTOSCALING("autoscaling"),
    CODE_DEPLOY_ROLLBACK("codeDeployRollback"),
    CODE_DEPLOY("CodeDeploy"),
    CODE_DEPLOY_AUTO_UPDATE("CodeDeployAutoUpdate"),
    CLOUD_FORMATION("CloudFormation"),
    CLOUD_FORMATION_ROLLBACK("CloudFormationRollback"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, DeploymentCreator> VALUE_MAP;
    private final String value;

    private DeploymentCreator(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DeploymentCreator fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DeploymentCreator> knownValues() {
        EnumSet<DeploymentCreator> knownValues = EnumSet.allOf(DeploymentCreator.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(DeploymentCreator.class, DeploymentCreator::toString);
    }
}

