/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.codedeploy.CodeDeployClient;
import software.amazon.awssdk.services.codedeploy.CodeDeployClientBuilder;
import software.amazon.awssdk.services.codedeploy.CodeDeployServiceClientConfiguration;
import software.amazon.awssdk.services.codedeploy.DefaultCodeDeployBaseClientBuilder;
import software.amazon.awssdk.services.codedeploy.DefaultCodeDeployClient;
import software.amazon.awssdk.services.codedeploy.endpoints.CodeDeployEndpointProvider;

@SdkInternalApi
final class DefaultCodeDeployClientBuilder
extends DefaultCodeDeployBaseClientBuilder<CodeDeployClientBuilder, CodeDeployClient>
implements CodeDeployClientBuilder {
    DefaultCodeDeployClientBuilder() {
    }

    @Override
    public DefaultCodeDeployClientBuilder endpointProvider(CodeDeployEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final CodeDeployClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultCodeDeployClientBuilder.validateClientOptions(clientConfiguration);
        CodeDeployServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultCodeDeployClient client = new DefaultCodeDeployClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private CodeDeployServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        EndpointProvider endpointProvider = (EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER);
        if (clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return CodeDeployServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider(endpointProvider).build();
    }
}

