/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codecommit.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.codecommit.model.BranchNameListCopier;
import software.amazon.awssdk.services.codecommit.model.CodeCommitResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListBranchesResponse
extends CodeCommitResponse
implements ToCopyableBuilder<Builder, ListBranchesResponse> {
    private static final SdkField<List<String>> BRANCHES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("branches").getter(ListBranchesResponse.getter(ListBranchesResponse::branches)).setter(ListBranchesResponse.setter(Builder::branches)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("branches").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListBranchesResponse.getter(ListBranchesResponse::nextToken)).setter(ListBranchesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BRANCHES_FIELD, NEXT_TOKEN_FIELD));
    private final List<String> branches;
    private final String nextToken;

    private ListBranchesResponse(BuilderImpl builder) {
        super(builder);
        this.branches = builder.branches;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasBranches() {
        return this.branches != null && !(this.branches instanceof SdkAutoConstructList);
    }

    public final List<String> branches() {
        return this.branches;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBranches() ? this.branches() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListBranchesResponse)) {
            return false;
        }
        ListBranchesResponse other = (ListBranchesResponse)((Object)obj);
        return this.hasBranches() == other.hasBranches() && Objects.equals(this.branches(), other.branches()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListBranchesResponse").add("Branches", this.hasBranches() ? this.branches() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "branches": {
                return Optional.ofNullable(clazz.cast(this.branches()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListBranchesResponse, T> g) {
        return obj -> g.apply((ListBranchesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodeCommitResponse.BuilderImpl
    implements Builder {
        private List<String> branches = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListBranchesResponse model) {
            super(model);
            this.branches(model.branches);
            this.nextToken(model.nextToken);
        }

        public final Collection<String> getBranches() {
            if (this.branches instanceof SdkAutoConstructList) {
                return null;
            }
            return this.branches;
        }

        public final void setBranches(Collection<String> branches) {
            this.branches = BranchNameListCopier.copy(branches);
        }

        @Override
        public final Builder branches(Collection<String> branches) {
            this.branches = BranchNameListCopier.copy(branches);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder branches(String ... branches) {
            this.branches(Arrays.asList(branches));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListBranchesResponse build() {
            return new ListBranchesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CodeCommitResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListBranchesResponse> {
        public Builder branches(Collection<String> var1);

        public Builder branches(String ... var1);

        public Builder nextToken(String var1);
    }
}

