/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codecommit.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SubModule
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SubModule> {
    private static final SdkField<String> COMMIT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("commitId").getter(SubModule.getter(SubModule::commitId)).setter(SubModule.setter(Builder::commitId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("commitId").build()}).build();
    private static final SdkField<String> ABSOLUTE_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("absolutePath").getter(SubModule.getter(SubModule::absolutePath)).setter(SubModule.setter(Builder::absolutePath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("absolutePath").build()}).build();
    private static final SdkField<String> RELATIVE_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("relativePath").getter(SubModule.getter(SubModule::relativePath)).setter(SubModule.setter(Builder::relativePath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("relativePath").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMMIT_ID_FIELD, ABSOLUTE_PATH_FIELD, RELATIVE_PATH_FIELD));
    private static final long serialVersionUID = 1L;
    private final String commitId;
    private final String absolutePath;
    private final String relativePath;

    private SubModule(BuilderImpl builder) {
        this.commitId = builder.commitId;
        this.absolutePath = builder.absolutePath;
        this.relativePath = builder.relativePath;
    }

    public final String commitId() {
        return this.commitId;
    }

    public final String absolutePath() {
        return this.absolutePath;
    }

    public final String relativePath() {
        return this.relativePath;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.commitId());
        hashCode = 31 * hashCode + Objects.hashCode(this.absolutePath());
        hashCode = 31 * hashCode + Objects.hashCode(this.relativePath());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SubModule)) {
            return false;
        }
        SubModule other = (SubModule)obj;
        return Objects.equals(this.commitId(), other.commitId()) && Objects.equals(this.absolutePath(), other.absolutePath()) && Objects.equals(this.relativePath(), other.relativePath());
    }

    public final String toString() {
        return ToString.builder((String)"SubModule").add("CommitId", (Object)this.commitId()).add("AbsolutePath", (Object)this.absolutePath()).add("RelativePath", (Object)this.relativePath()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "commitId": {
                return Optional.ofNullable(clazz.cast(this.commitId()));
            }
            case "absolutePath": {
                return Optional.ofNullable(clazz.cast(this.absolutePath()));
            }
            case "relativePath": {
                return Optional.ofNullable(clazz.cast(this.relativePath()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SubModule, T> g) {
        return obj -> g.apply((SubModule)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String commitId;
        private String absolutePath;
        private String relativePath;

        private BuilderImpl() {
        }

        private BuilderImpl(SubModule model) {
            this.commitId(model.commitId);
            this.absolutePath(model.absolutePath);
            this.relativePath(model.relativePath);
        }

        public final String getCommitId() {
            return this.commitId;
        }

        public final void setCommitId(String commitId) {
            this.commitId = commitId;
        }

        @Override
        public final Builder commitId(String commitId) {
            this.commitId = commitId;
            return this;
        }

        public final String getAbsolutePath() {
            return this.absolutePath;
        }

        public final void setAbsolutePath(String absolutePath) {
            this.absolutePath = absolutePath;
        }

        @Override
        public final Builder absolutePath(String absolutePath) {
            this.absolutePath = absolutePath;
            return this;
        }

        public final String getRelativePath() {
            return this.relativePath;
        }

        public final void setRelativePath(String relativePath) {
            this.relativePath = relativePath;
        }

        @Override
        public final Builder relativePath(String relativePath) {
            this.relativePath = relativePath;
            return this;
        }

        public SubModule build() {
            return new SubModule(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SubModule> {
        public Builder commitId(String var1);

        public Builder absolutePath(String var1);

        public Builder relativePath(String var1);
    }
}

