/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codecommit.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.codecommit.CodeCommitAsyncClient;
import software.amazon.awssdk.services.codecommit.internal.UserAgentUtils;
import software.amazon.awssdk.services.codecommit.model.ListRepositoriesForApprovalRuleTemplateRequest;
import software.amazon.awssdk.services.codecommit.model.ListRepositoriesForApprovalRuleTemplateResponse;

public class ListRepositoriesForApprovalRuleTemplatePublisher
implements SdkPublisher<ListRepositoriesForApprovalRuleTemplateResponse> {
    private final CodeCommitAsyncClient client;
    private final ListRepositoriesForApprovalRuleTemplateRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListRepositoriesForApprovalRuleTemplatePublisher(CodeCommitAsyncClient client, ListRepositoriesForApprovalRuleTemplateRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListRepositoriesForApprovalRuleTemplatePublisher(CodeCommitAsyncClient client, ListRepositoriesForApprovalRuleTemplateRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListRepositoriesForApprovalRuleTemplateResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListRepositoriesForApprovalRuleTemplateResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListRepositoriesForApprovalRuleTemplateResponseFetcher
    implements AsyncPageFetcher<ListRepositoriesForApprovalRuleTemplateResponse> {
        private ListRepositoriesForApprovalRuleTemplateResponseFetcher() {
        }

        public boolean hasNextPage(ListRepositoriesForApprovalRuleTemplateResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListRepositoriesForApprovalRuleTemplateResponse> nextPage(ListRepositoriesForApprovalRuleTemplateResponse previousPage) {
            if (previousPage == null) {
                return ListRepositoriesForApprovalRuleTemplatePublisher.this.client.listRepositoriesForApprovalRuleTemplate(ListRepositoriesForApprovalRuleTemplatePublisher.this.firstRequest);
            }
            return ListRepositoriesForApprovalRuleTemplatePublisher.this.client.listRepositoriesForApprovalRuleTemplate((ListRepositoriesForApprovalRuleTemplateRequest)((Object)ListRepositoriesForApprovalRuleTemplatePublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

