/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codebuild.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetReportGroupTrendResponse extends CodeBuildResponse implements
        ToCopyableBuilder<GetReportGroupTrendResponse.Builder, GetReportGroupTrendResponse> {
    private static final SdkField<ReportGroupTrendStats> STATS_FIELD = SdkField
            .<ReportGroupTrendStats> builder(MarshallingType.SDK_POJO).memberName("stats")
            .getter(getter(GetReportGroupTrendResponse::stats)).setter(setter(Builder::stats))
            .constructor(ReportGroupTrendStats::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stats").build()).build();

    private static final SdkField<List<ReportWithRawData>> RAW_DATA_FIELD = SdkField
            .<List<ReportWithRawData>> builder(MarshallingType.LIST)
            .memberName("rawData")
            .getter(getter(GetReportGroupTrendResponse::rawData))
            .setter(setter(Builder::rawData))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rawData").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ReportWithRawData> builder(MarshallingType.SDK_POJO)
                                            .constructor(ReportWithRawData::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATS_FIELD, RAW_DATA_FIELD));

    private final ReportGroupTrendStats stats;

    private final List<ReportWithRawData> rawData;

    private GetReportGroupTrendResponse(BuilderImpl builder) {
        super(builder);
        this.stats = builder.stats;
        this.rawData = builder.rawData;
    }

    /**
     * <p>
     * Contains the accumulated trend data.
     * </p>
     * 
     * @return Contains the accumulated trend data.
     */
    public final ReportGroupTrendStats stats() {
        return stats;
    }

    /**
     * For responses, this returns true if the service returned a value for the RawData property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasRawData() {
        return rawData != null && !(rawData instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array that contains the raw data for each report.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRawData} method.
     * </p>
     * 
     * @return An array that contains the raw data for each report.
     */
    public final List<ReportWithRawData> rawData() {
        return rawData;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(stats());
        hashCode = 31 * hashCode + Objects.hashCode(hasRawData() ? rawData() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetReportGroupTrendResponse)) {
            return false;
        }
        GetReportGroupTrendResponse other = (GetReportGroupTrendResponse) obj;
        return Objects.equals(stats(), other.stats()) && hasRawData() == other.hasRawData()
                && Objects.equals(rawData(), other.rawData());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetReportGroupTrendResponse").add("Stats", stats())
                .add("RawData", hasRawData() ? rawData() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "stats":
            return Optional.ofNullable(clazz.cast(stats()));
        case "rawData":
            return Optional.ofNullable(clazz.cast(rawData()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetReportGroupTrendResponse, T> g) {
        return obj -> g.apply((GetReportGroupTrendResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeBuildResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetReportGroupTrendResponse> {
        /**
         * <p>
         * Contains the accumulated trend data.
         * </p>
         * 
         * @param stats
         *        Contains the accumulated trend data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stats(ReportGroupTrendStats stats);

        /**
         * <p>
         * Contains the accumulated trend data.
         * </p>
         * This is a convenience method that creates an instance of the {@link ReportGroupTrendStats.Builder} avoiding
         * the need to create one manually via {@link ReportGroupTrendStats#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ReportGroupTrendStats.Builder#build()} is called immediately and
         * its result is passed to {@link #stats(ReportGroupTrendStats)}.
         * 
         * @param stats
         *        a consumer that will call methods on {@link ReportGroupTrendStats.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #stats(ReportGroupTrendStats)
         */
        default Builder stats(Consumer<ReportGroupTrendStats.Builder> stats) {
            return stats(ReportGroupTrendStats.builder().applyMutation(stats).build());
        }

        /**
         * <p>
         * An array that contains the raw data for each report.
         * </p>
         * 
         * @param rawData
         *        An array that contains the raw data for each report.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rawData(Collection<ReportWithRawData> rawData);

        /**
         * <p>
         * An array that contains the raw data for each report.
         * </p>
         * 
         * @param rawData
         *        An array that contains the raw data for each report.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rawData(ReportWithRawData... rawData);

        /**
         * <p>
         * An array that contains the raw data for each report.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.codebuild.model.ReportWithRawData.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.codebuild.model.ReportWithRawData#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.codebuild.model.ReportWithRawData.Builder#build()} is called
         * immediately and its result is passed to {@link #rawData(List<ReportWithRawData>)}.
         * 
         * @param rawData
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.codebuild.model.ReportWithRawData.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rawData(java.util.Collection<ReportWithRawData>)
         */
        Builder rawData(Consumer<ReportWithRawData.Builder>... rawData);
    }

    static final class BuilderImpl extends CodeBuildResponse.BuilderImpl implements Builder {
        private ReportGroupTrendStats stats;

        private List<ReportWithRawData> rawData = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetReportGroupTrendResponse model) {
            super(model);
            stats(model.stats);
            rawData(model.rawData);
        }

        public final ReportGroupTrendStats.Builder getStats() {
            return stats != null ? stats.toBuilder() : null;
        }

        public final void setStats(ReportGroupTrendStats.BuilderImpl stats) {
            this.stats = stats != null ? stats.build() : null;
        }

        @Override
        public final Builder stats(ReportGroupTrendStats stats) {
            this.stats = stats;
            return this;
        }

        public final List<ReportWithRawData.Builder> getRawData() {
            List<ReportWithRawData.Builder> result = ReportGroupTrendRawDataListCopier.copyToBuilder(this.rawData);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRawData(Collection<ReportWithRawData.BuilderImpl> rawData) {
            this.rawData = ReportGroupTrendRawDataListCopier.copyFromBuilder(rawData);
        }

        @Override
        public final Builder rawData(Collection<ReportWithRawData> rawData) {
            this.rawData = ReportGroupTrendRawDataListCopier.copy(rawData);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rawData(ReportWithRawData... rawData) {
            rawData(Arrays.asList(rawData));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rawData(Consumer<ReportWithRawData.Builder>... rawData) {
            rawData(Stream.of(rawData).map(c -> ReportWithRawData.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public GetReportGroupTrendResponse build() {
            return new GetReportGroupTrendResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
