/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codeartifact.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum PackageFormat {
    NPM("npm"),
    PYPI("pypi"),
    MAVEN("maven"),
    NUGET("nuget"),
    GENERIC("generic"),
    SWIFT("swift"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, PackageFormat> VALUE_MAP;
    private final String value;

    private PackageFormat(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static PackageFormat fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<PackageFormat> knownValues() {
        EnumSet<PackageFormat> knownValues = EnumSet.allOf(PackageFormat.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(PackageFormat.class, PackageFormat::toString);
    }
}

