/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codeartifact.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum PackageVersionSortType {
    PUBLISHED_TIME("PUBLISHED_TIME"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, PackageVersionSortType> VALUE_MAP;
    private final String value;

    private PackageVersionSortType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static PackageVersionSortType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<PackageVersionSortType> knownValues() {
        EnumSet<PackageVersionSortType> knownValues = EnumSet.allOf(PackageVersionSortType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(PackageVersionSortType.class, PackageVersionSortType::toString);
    }
}

