/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codeartifact;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.codeartifact.CodeartifactAsyncClient;
import software.amazon.awssdk.services.codeartifact.CodeartifactAsyncClientBuilder;
import software.amazon.awssdk.services.codeartifact.CodeartifactServiceClientConfiguration;
import software.amazon.awssdk.services.codeartifact.DefaultCodeartifactAsyncClient;
import software.amazon.awssdk.services.codeartifact.DefaultCodeartifactBaseClientBuilder;
import software.amazon.awssdk.services.codeartifact.endpoints.CodeartifactEndpointProvider;

@SdkInternalApi
final class DefaultCodeartifactAsyncClientBuilder
extends DefaultCodeartifactBaseClientBuilder<CodeartifactAsyncClientBuilder, CodeartifactAsyncClient>
implements CodeartifactAsyncClientBuilder {
    DefaultCodeartifactAsyncClientBuilder() {
    }

    @Override
    public DefaultCodeartifactAsyncClientBuilder endpointProvider(CodeartifactEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final CodeartifactAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultCodeartifactAsyncClientBuilder.validateClientOptions(clientConfiguration);
        CodeartifactServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultCodeartifactAsyncClient client = new DefaultCodeartifactAsyncClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private CodeartifactServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        EndpointProvider endpointProvider = (EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER);
        if (clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return CodeartifactServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider(endpointProvider).build();
    }
}

