/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cloudwatchlogs.CloudWatchLogsClient;
import software.amazon.awssdk.services.cloudwatchlogs.internal.UserAgentUtils;
import software.amazon.awssdk.services.cloudwatchlogs.model.DescribeLogGroupsRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.DescribeLogGroupsResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.LogGroup;

public class DescribeLogGroupsIterable
implements SdkIterable<DescribeLogGroupsResponse> {
    private final CloudWatchLogsClient client;
    private final DescribeLogGroupsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeLogGroupsIterable(CloudWatchLogsClient client, DescribeLogGroupsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeLogGroupsResponseFetcher();
    }

    public Iterator<DescribeLogGroupsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<LogGroup> logGroups() {
        Function<DescribeLogGroupsResponse, Iterator> getIterator = response -> {
            if (response != null && response.logGroups() != null) {
                return response.logGroups().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeLogGroupsResponseFetcher
    implements SyncPageFetcher<DescribeLogGroupsResponse> {
        private DescribeLogGroupsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeLogGroupsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeLogGroupsResponse nextPage(DescribeLogGroupsResponse previousPage) {
            if (previousPage == null) {
                return DescribeLogGroupsIterable.this.client.describeLogGroups(DescribeLogGroupsIterable.this.firstRequest);
            }
            return DescribeLogGroupsIterable.this.client.describeLogGroups((DescribeLogGroupsRequest)((Object)DescribeLogGroupsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

