/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cloudwatchlogs.CloudWatchLogsClient;
import software.amazon.awssdk.services.cloudwatchlogs.internal.UserAgentUtils;
import software.amazon.awssdk.services.cloudwatchlogs.model.DeliverySource;
import software.amazon.awssdk.services.cloudwatchlogs.model.DescribeDeliverySourcesRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.DescribeDeliverySourcesResponse;

public class DescribeDeliverySourcesIterable
implements SdkIterable<DescribeDeliverySourcesResponse> {
    private final CloudWatchLogsClient client;
    private final DescribeDeliverySourcesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeDeliverySourcesIterable(CloudWatchLogsClient client, DescribeDeliverySourcesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeDeliverySourcesResponseFetcher();
    }

    public Iterator<DescribeDeliverySourcesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<DeliverySource> deliverySources() {
        Function<DescribeDeliverySourcesResponse, Iterator> getIterator = response -> {
            if (response != null && response.deliverySources() != null) {
                return response.deliverySources().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeDeliverySourcesResponseFetcher
    implements SyncPageFetcher<DescribeDeliverySourcesResponse> {
        private DescribeDeliverySourcesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeDeliverySourcesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeDeliverySourcesResponse nextPage(DescribeDeliverySourcesResponse previousPage) {
            if (previousPage == null) {
                return DescribeDeliverySourcesIterable.this.client.describeDeliverySources(DescribeDeliverySourcesIterable.this.firstRequest);
            }
            return DescribeDeliverySourcesIterable.this.client.describeDeliverySources((DescribeDeliverySourcesRequest)((Object)DescribeDeliverySourcesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

