/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudwatchlogs.model.LogGroupClass;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LogGroupSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LogGroupSummary> {
    private static final SdkField<String> LOG_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("logGroupName").getter(LogGroupSummary.getter(LogGroupSummary::logGroupName)).setter(LogGroupSummary.setter(Builder::logGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logGroupName").build()}).build();
    private static final SdkField<String> LOG_GROUP_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("logGroupArn").getter(LogGroupSummary.getter(LogGroupSummary::logGroupArn)).setter(LogGroupSummary.setter(Builder::logGroupArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logGroupArn").build()}).build();
    private static final SdkField<String> LOG_GROUP_CLASS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("logGroupClass").getter(LogGroupSummary.getter(LogGroupSummary::logGroupClassAsString)).setter(LogGroupSummary.setter(Builder::logGroupClass)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logGroupClass").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOG_GROUP_NAME_FIELD, LOG_GROUP_ARN_FIELD, LOG_GROUP_CLASS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = LogGroupSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String logGroupName;
    private final String logGroupArn;
    private final String logGroupClass;

    private LogGroupSummary(BuilderImpl builder) {
        this.logGroupName = builder.logGroupName;
        this.logGroupArn = builder.logGroupArn;
        this.logGroupClass = builder.logGroupClass;
    }

    public final String logGroupName() {
        return this.logGroupName;
    }

    public final String logGroupArn() {
        return this.logGroupArn;
    }

    public final LogGroupClass logGroupClass() {
        return LogGroupClass.fromValue(this.logGroupClass);
    }

    public final String logGroupClassAsString() {
        return this.logGroupClass;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.logGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.logGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.logGroupClassAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LogGroupSummary)) {
            return false;
        }
        LogGroupSummary other = (LogGroupSummary)obj;
        return Objects.equals(this.logGroupName(), other.logGroupName()) && Objects.equals(this.logGroupArn(), other.logGroupArn()) && Objects.equals(this.logGroupClassAsString(), other.logGroupClassAsString());
    }

    public final String toString() {
        return ToString.builder((String)"LogGroupSummary").add("LogGroupName", (Object)this.logGroupName()).add("LogGroupArn", (Object)this.logGroupArn()).add("LogGroupClass", (Object)this.logGroupClassAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "logGroupName": {
                return Optional.ofNullable(clazz.cast(this.logGroupName()));
            }
            case "logGroupArn": {
                return Optional.ofNullable(clazz.cast(this.logGroupArn()));
            }
            case "logGroupClass": {
                return Optional.ofNullable(clazz.cast(this.logGroupClassAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("logGroupName", LOG_GROUP_NAME_FIELD);
        map.put("logGroupArn", LOG_GROUP_ARN_FIELD);
        map.put("logGroupClass", LOG_GROUP_CLASS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LogGroupSummary, T> g) {
        return obj -> g.apply((LogGroupSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String logGroupName;
        private String logGroupArn;
        private String logGroupClass;

        private BuilderImpl() {
        }

        private BuilderImpl(LogGroupSummary model) {
            this.logGroupName(model.logGroupName);
            this.logGroupArn(model.logGroupArn);
            this.logGroupClass(model.logGroupClass);
        }

        public final String getLogGroupName() {
            return this.logGroupName;
        }

        public final void setLogGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
        }

        @Override
        public final Builder logGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
            return this;
        }

        public final String getLogGroupArn() {
            return this.logGroupArn;
        }

        public final void setLogGroupArn(String logGroupArn) {
            this.logGroupArn = logGroupArn;
        }

        @Override
        public final Builder logGroupArn(String logGroupArn) {
            this.logGroupArn = logGroupArn;
            return this;
        }

        public final String getLogGroupClass() {
            return this.logGroupClass;
        }

        public final void setLogGroupClass(String logGroupClass) {
            this.logGroupClass = logGroupClass;
        }

        @Override
        public final Builder logGroupClass(String logGroupClass) {
            this.logGroupClass = logGroupClass;
            return this;
        }

        @Override
        public final Builder logGroupClass(LogGroupClass logGroupClass) {
            this.logGroupClass(logGroupClass == null ? null : logGroupClass.toString());
            return this;
        }

        public LogGroupSummary build() {
            return new LogGroupSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LogGroupSummary> {
        public Builder logGroupName(String var1);

        public Builder logGroupArn(String var1);

        public Builder logGroupClass(String var1);

        public Builder logGroupClass(LogGroupClass var1);
    }
}

