/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudwatchlogs.model.CloudWatchLogsResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.SubscriptionFilter;
import software.amazon.awssdk.services.cloudwatchlogs.model.SubscriptionFiltersCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeSubscriptionFiltersResponse
extends CloudWatchLogsResponse
implements ToCopyableBuilder<Builder, DescribeSubscriptionFiltersResponse> {
    private static final SdkField<List<SubscriptionFilter>> SUBSCRIPTION_FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("subscriptionFilters").getter(DescribeSubscriptionFiltersResponse.getter(DescribeSubscriptionFiltersResponse::subscriptionFilters)).setter(DescribeSubscriptionFiltersResponse.setter(Builder::subscriptionFilters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subscriptionFilters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SubscriptionFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(DescribeSubscriptionFiltersResponse.getter(DescribeSubscriptionFiltersResponse::nextToken)).setter(DescribeSubscriptionFiltersResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUBSCRIPTION_FILTERS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeSubscriptionFiltersResponse.memberNameToFieldInitializer();
    private final List<SubscriptionFilter> subscriptionFilters;
    private final String nextToken;

    private DescribeSubscriptionFiltersResponse(BuilderImpl builder) {
        super(builder);
        this.subscriptionFilters = builder.subscriptionFilters;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasSubscriptionFilters() {
        return this.subscriptionFilters != null && !(this.subscriptionFilters instanceof SdkAutoConstructList);
    }

    public final List<SubscriptionFilter> subscriptionFilters() {
        return this.subscriptionFilters;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSubscriptionFilters() ? this.subscriptionFilters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSubscriptionFiltersResponse)) {
            return false;
        }
        DescribeSubscriptionFiltersResponse other = (DescribeSubscriptionFiltersResponse)((Object)obj);
        return this.hasSubscriptionFilters() == other.hasSubscriptionFilters() && Objects.equals(this.subscriptionFilters(), other.subscriptionFilters()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeSubscriptionFiltersResponse").add("SubscriptionFilters", this.hasSubscriptionFilters() ? this.subscriptionFilters() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "subscriptionFilters": {
                return Optional.ofNullable(clazz.cast(this.subscriptionFilters()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("subscriptionFilters", SUBSCRIPTION_FILTERS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeSubscriptionFiltersResponse, T> g) {
        return obj -> g.apply((DescribeSubscriptionFiltersResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudWatchLogsResponse.BuilderImpl
    implements Builder {
        private List<SubscriptionFilter> subscriptionFilters = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeSubscriptionFiltersResponse model) {
            super(model);
            this.subscriptionFilters(model.subscriptionFilters);
            this.nextToken(model.nextToken);
        }

        public final List<SubscriptionFilter.Builder> getSubscriptionFilters() {
            List<SubscriptionFilter.Builder> result = SubscriptionFiltersCopier.copyToBuilder(this.subscriptionFilters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSubscriptionFilters(Collection<SubscriptionFilter.BuilderImpl> subscriptionFilters) {
            this.subscriptionFilters = SubscriptionFiltersCopier.copyFromBuilder(subscriptionFilters);
        }

        @Override
        public final Builder subscriptionFilters(Collection<SubscriptionFilter> subscriptionFilters) {
            this.subscriptionFilters = SubscriptionFiltersCopier.copy(subscriptionFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subscriptionFilters(SubscriptionFilter ... subscriptionFilters) {
            this.subscriptionFilters(Arrays.asList(subscriptionFilters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subscriptionFilters(Consumer<SubscriptionFilter.Builder> ... subscriptionFilters) {
            this.subscriptionFilters(Stream.of(subscriptionFilters).map(c -> (SubscriptionFilter)((SubscriptionFilter.Builder)SubscriptionFilter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeSubscriptionFiltersResponse build() {
            return new DescribeSubscriptionFiltersResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends CloudWatchLogsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeSubscriptionFiltersResponse> {
        public Builder subscriptionFilters(Collection<SubscriptionFilter> var1);

        public Builder subscriptionFilters(SubscriptionFilter ... var1);

        public Builder subscriptionFilters(Consumer<SubscriptionFilter.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

