/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudwatchlogs.model.CloudWatchLogsResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.Delivery;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateDeliveryResponse
extends CloudWatchLogsResponse
implements ToCopyableBuilder<Builder, CreateDeliveryResponse> {
    private static final SdkField<Delivery> DELIVERY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("delivery").getter(CreateDeliveryResponse.getter(CreateDeliveryResponse::delivery)).setter(CreateDeliveryResponse.setter(Builder::delivery)).constructor(Delivery::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("delivery").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DELIVERY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateDeliveryResponse.memberNameToFieldInitializer();
    private final Delivery delivery;

    private CreateDeliveryResponse(BuilderImpl builder) {
        super(builder);
        this.delivery = builder.delivery;
    }

    public final Delivery delivery() {
        return this.delivery;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.delivery());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDeliveryResponse)) {
            return false;
        }
        CreateDeliveryResponse other = (CreateDeliveryResponse)((Object)obj);
        return Objects.equals(this.delivery(), other.delivery());
    }

    public final String toString() {
        return ToString.builder((String)"CreateDeliveryResponse").add("Delivery", (Object)this.delivery()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "delivery": {
                return Optional.ofNullable(clazz.cast(this.delivery()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<Delivery>> map = new HashMap<String, SdkField<Delivery>>();
        map.put("delivery", DELIVERY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateDeliveryResponse, T> g) {
        return obj -> g.apply((CreateDeliveryResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudWatchLogsResponse.BuilderImpl
    implements Builder {
        private Delivery delivery;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDeliveryResponse model) {
            super(model);
            this.delivery(model.delivery);
        }

        public final Delivery.Builder getDelivery() {
            return this.delivery != null ? this.delivery.toBuilder() : null;
        }

        public final void setDelivery(Delivery.BuilderImpl delivery) {
            this.delivery = delivery != null ? delivery.build() : null;
        }

        @Override
        public final Builder delivery(Delivery delivery) {
            this.delivery = delivery;
            return this;
        }

        @Override
        public CreateDeliveryResponse build() {
            return new CreateDeliveryResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends CloudWatchLogsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateDeliveryResponse> {
        public Builder delivery(Delivery var1);

        default public Builder delivery(Consumer<Delivery.Builder> delivery) {
            return this.delivery((Delivery)((Delivery.Builder)Delivery.builder().applyMutation(delivery)).build());
        }
    }
}

