/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CopyValueEntry
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CopyValueEntry> {
    private static final SdkField<String> SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("source").getter(CopyValueEntry.getter(CopyValueEntry::source)).setter(CopyValueEntry.setter(Builder::source)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("source").build()}).build();
    private static final SdkField<String> TARGET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("target").getter(CopyValueEntry.getter(CopyValueEntry::target)).setter(CopyValueEntry.setter(Builder::target)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("target").build()}).build();
    private static final SdkField<Boolean> OVERWRITE_IF_EXISTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("overwriteIfExists").getter(CopyValueEntry.getter(CopyValueEntry::overwriteIfExists)).setter(CopyValueEntry.setter(Builder::overwriteIfExists)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("overwriteIfExists").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_FIELD, TARGET_FIELD, OVERWRITE_IF_EXISTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CopyValueEntry.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String source;
    private final String target;
    private final Boolean overwriteIfExists;

    private CopyValueEntry(BuilderImpl builder) {
        this.source = builder.source;
        this.target = builder.target;
        this.overwriteIfExists = builder.overwriteIfExists;
    }

    public final String source() {
        return this.source;
    }

    public final String target() {
        return this.target;
    }

    public final Boolean overwriteIfExists() {
        return this.overwriteIfExists;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.source());
        hashCode = 31 * hashCode + Objects.hashCode(this.target());
        hashCode = 31 * hashCode + Objects.hashCode(this.overwriteIfExists());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CopyValueEntry)) {
            return false;
        }
        CopyValueEntry other = (CopyValueEntry)obj;
        return Objects.equals(this.source(), other.source()) && Objects.equals(this.target(), other.target()) && Objects.equals(this.overwriteIfExists(), other.overwriteIfExists());
    }

    public final String toString() {
        return ToString.builder((String)"CopyValueEntry").add("Source", (Object)this.source()).add("Target", (Object)this.target()).add("OverwriteIfExists", (Object)this.overwriteIfExists()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "source": {
                return Optional.ofNullable(clazz.cast(this.source()));
            }
            case "target": {
                return Optional.ofNullable(clazz.cast(this.target()));
            }
            case "overwriteIfExists": {
                return Optional.ofNullable(clazz.cast(this.overwriteIfExists()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("source", SOURCE_FIELD);
        map.put("target", TARGET_FIELD);
        map.put("overwriteIfExists", OVERWRITE_IF_EXISTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CopyValueEntry, T> g) {
        return obj -> g.apply((CopyValueEntry)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String source;
        private String target;
        private Boolean overwriteIfExists;

        private BuilderImpl() {
        }

        private BuilderImpl(CopyValueEntry model) {
            this.source(model.source);
            this.target(model.target);
            this.overwriteIfExists(model.overwriteIfExists);
        }

        public final String getSource() {
            return this.source;
        }

        public final void setSource(String source) {
            this.source = source;
        }

        @Override
        public final Builder source(String source) {
            this.source = source;
            return this;
        }

        public final String getTarget() {
            return this.target;
        }

        public final void setTarget(String target) {
            this.target = target;
        }

        @Override
        public final Builder target(String target) {
            this.target = target;
            return this;
        }

        public final Boolean getOverwriteIfExists() {
            return this.overwriteIfExists;
        }

        public final void setOverwriteIfExists(Boolean overwriteIfExists) {
            this.overwriteIfExists = overwriteIfExists;
        }

        @Override
        public final Builder overwriteIfExists(Boolean overwriteIfExists) {
            this.overwriteIfExists = overwriteIfExists;
            return this;
        }

        public CopyValueEntry build() {
            return new CopyValueEntry(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CopyValueEntry> {
        public Builder source(String var1);

        public Builder target(String var1);

        public Builder overwriteIfExists(Boolean var1);
    }
}

