/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudfront.model.ResponseHeadersPolicyConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ResponseHeadersPolicy
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ResponseHeadersPolicy> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(ResponseHeadersPolicy.getter(ResponseHeadersPolicy::id)).setter(ResponseHeadersPolicy.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").unmarshallLocationName("Id").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastModifiedTime").getter(ResponseHeadersPolicy.getter(ResponseHeadersPolicy::lastModifiedTime)).setter(ResponseHeadersPolicy.setter(Builder::lastModifiedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").unmarshallLocationName("LastModifiedTime").build()}).build();
    private static final SdkField<ResponseHeadersPolicyConfig> RESPONSE_HEADERS_POLICY_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ResponseHeadersPolicyConfig").getter(ResponseHeadersPolicy.getter(ResponseHeadersPolicy::responseHeadersPolicyConfig)).setter(ResponseHeadersPolicy.setter(Builder::responseHeadersPolicyConfig)).constructor(ResponseHeadersPolicyConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResponseHeadersPolicyConfig").unmarshallLocationName("ResponseHeadersPolicyConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, LAST_MODIFIED_TIME_FIELD, RESPONSE_HEADERS_POLICY_CONFIG_FIELD));
    private static final long serialVersionUID = 1L;
    private final String id;
    private final Instant lastModifiedTime;
    private final ResponseHeadersPolicyConfig responseHeadersPolicyConfig;

    private ResponseHeadersPolicy(BuilderImpl builder) {
        this.id = builder.id;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.responseHeadersPolicyConfig = builder.responseHeadersPolicyConfig;
    }

    public final String id() {
        return this.id;
    }

    public final Instant lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public final ResponseHeadersPolicyConfig responseHeadersPolicyConfig() {
        return this.responseHeadersPolicyConfig;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.responseHeadersPolicyConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResponseHeadersPolicy)) {
            return false;
        }
        ResponseHeadersPolicy other = (ResponseHeadersPolicy)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.lastModifiedTime(), other.lastModifiedTime()) && Objects.equals(this.responseHeadersPolicyConfig(), other.responseHeadersPolicyConfig());
    }

    public final String toString() {
        return ToString.builder((String)"ResponseHeadersPolicy").add("Id", (Object)this.id()).add("LastModifiedTime", (Object)this.lastModifiedTime()).add("ResponseHeadersPolicyConfig", (Object)this.responseHeadersPolicyConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "LastModifiedTime": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedTime()));
            }
            case "ResponseHeadersPolicyConfig": {
                return Optional.ofNullable(clazz.cast(this.responseHeadersPolicyConfig()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ResponseHeadersPolicy, T> g) {
        return obj -> g.apply((ResponseHeadersPolicy)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private Instant lastModifiedTime;
        private ResponseHeadersPolicyConfig responseHeadersPolicyConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(ResponseHeadersPolicy model) {
            this.id(model.id);
            this.lastModifiedTime(model.lastModifiedTime);
            this.responseHeadersPolicyConfig(model.responseHeadersPolicyConfig);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return this.lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final ResponseHeadersPolicyConfig.Builder getResponseHeadersPolicyConfig() {
            return this.responseHeadersPolicyConfig != null ? this.responseHeadersPolicyConfig.toBuilder() : null;
        }

        public final void setResponseHeadersPolicyConfig(ResponseHeadersPolicyConfig.BuilderImpl responseHeadersPolicyConfig) {
            this.responseHeadersPolicyConfig = responseHeadersPolicyConfig != null ? responseHeadersPolicyConfig.build() : null;
        }

        @Override
        public final Builder responseHeadersPolicyConfig(ResponseHeadersPolicyConfig responseHeadersPolicyConfig) {
            this.responseHeadersPolicyConfig = responseHeadersPolicyConfig;
            return this;
        }

        public ResponseHeadersPolicy build() {
            return new ResponseHeadersPolicy(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ResponseHeadersPolicy> {
        public Builder id(String var1);

        public Builder lastModifiedTime(Instant var1);

        public Builder responseHeadersPolicyConfig(ResponseHeadersPolicyConfig var1);

        default public Builder responseHeadersPolicyConfig(Consumer<ResponseHeadersPolicyConfig.Builder> responseHeadersPolicyConfig) {
            return this.responseHeadersPolicyConfig((ResponseHeadersPolicyConfig)((ResponseHeadersPolicyConfig.Builder)ResponseHeadersPolicyConfig.builder().applyMutation(responseHeadersPolicyConfig)).build());
        }
    }
}

