/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Export
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Export> {
    private static final SdkField<String> EXPORTING_STACK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExportingStackId").getter(Export.getter(Export::exportingStackId)).setter(Export.setter(Builder::exportingStackId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExportingStackId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(Export.getter(Export::name)).setter(Export.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Value").getter(Export.getter(Export::value)).setter(Export.setter(Builder::value)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXPORTING_STACK_ID_FIELD, NAME_FIELD, VALUE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String exportingStackId;
    private final String name;
    private final String value;

    private Export(BuilderImpl builder) {
        this.exportingStackId = builder.exportingStackId;
        this.name = builder.name;
        this.value = builder.value;
    }

    public final String exportingStackId() {
        return this.exportingStackId;
    }

    public final String name() {
        return this.name;
    }

    public final String value() {
        return this.value;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.exportingStackId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.value());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Export)) {
            return false;
        }
        Export other = (Export)obj;
        return Objects.equals(this.exportingStackId(), other.exportingStackId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.value(), other.value());
    }

    public final String toString() {
        return ToString.builder((String)"Export").add("ExportingStackId", (Object)this.exportingStackId()).add("Name", (Object)this.name()).add("Value", (Object)this.value()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ExportingStackId": {
                return Optional.ofNullable(clazz.cast(this.exportingStackId()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Value": {
                return Optional.ofNullable(clazz.cast(this.value()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Export, T> g) {
        return obj -> g.apply((Export)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String exportingStackId;
        private String name;
        private String value;

        private BuilderImpl() {
        }

        private BuilderImpl(Export model) {
            this.exportingStackId(model.exportingStackId);
            this.name(model.name);
            this.value(model.value);
        }

        public final String getExportingStackId() {
            return this.exportingStackId;
        }

        public final void setExportingStackId(String exportingStackId) {
            this.exportingStackId = exportingStackId;
        }

        @Override
        public final Builder exportingStackId(String exportingStackId) {
            this.exportingStackId = exportingStackId;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getValue() {
            return this.value;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        public Export build() {
            return new Export(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Export> {
        public Builder exportingStackId(String var1);

        public Builder name(String var1);

        public Builder value(String var1);
    }
}

