/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloud9.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloud9.model.Cloud9Response;
import software.amazon.awssdk.services.cloud9.model.Environment;
import software.amazon.awssdk.services.cloud9.model.EnvironmentListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeEnvironmentsResponse
extends Cloud9Response
implements ToCopyableBuilder<Builder, DescribeEnvironmentsResponse> {
    private static final SdkField<List<Environment>> ENVIRONMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("environments").getter(DescribeEnvironmentsResponse.getter(DescribeEnvironmentsResponse::environments)).setter(DescribeEnvironmentsResponse.setter(Builder::environments)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environments").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Environment::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENVIRONMENTS_FIELD));
    private final List<Environment> environments;

    private DescribeEnvironmentsResponse(BuilderImpl builder) {
        super(builder);
        this.environments = builder.environments;
    }

    public final boolean hasEnvironments() {
        return this.environments != null && !(this.environments instanceof SdkAutoConstructList);
    }

    public final List<Environment> environments() {
        return this.environments;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEnvironments() ? this.environments() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeEnvironmentsResponse)) {
            return false;
        }
        DescribeEnvironmentsResponse other = (DescribeEnvironmentsResponse)((Object)obj);
        return this.hasEnvironments() == other.hasEnvironments() && Objects.equals(this.environments(), other.environments());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeEnvironmentsResponse").add("Environments", this.hasEnvironments() ? this.environments() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "environments": {
                return Optional.ofNullable(clazz.cast(this.environments()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeEnvironmentsResponse, T> g) {
        return obj -> g.apply((DescribeEnvironmentsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Cloud9Response.BuilderImpl
    implements Builder {
        private List<Environment> environments = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeEnvironmentsResponse model) {
            super(model);
            this.environments(model.environments);
        }

        public final List<Environment.Builder> getEnvironments() {
            List<Environment.Builder> result = EnvironmentListCopier.copyToBuilder(this.environments);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEnvironments(Collection<Environment.BuilderImpl> environments) {
            this.environments = EnvironmentListCopier.copyFromBuilder(environments);
        }

        @Override
        public final Builder environments(Collection<Environment> environments) {
            this.environments = EnvironmentListCopier.copy(environments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder environments(Environment ... environments) {
            this.environments(Arrays.asList(environments));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder environments(Consumer<Environment.Builder> ... environments) {
            this.environments(Stream.of(environments).map(c -> (Environment)((Environment.Builder)Environment.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeEnvironmentsResponse build() {
            return new DescribeEnvironmentsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Cloud9Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeEnvironmentsResponse> {
        public Builder environments(Collection<Environment> var1);

        public Builder environments(Environment ... var1);

        public Builder environments(Consumer<Environment.Builder> ... var1);
    }
}

