/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloud9;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.cloud9.Cloud9AsyncClient;
import software.amazon.awssdk.services.cloud9.Cloud9AsyncClientBuilder;
import software.amazon.awssdk.services.cloud9.Cloud9ServiceClientConfiguration;
import software.amazon.awssdk.services.cloud9.DefaultCloud9AsyncClient;
import software.amazon.awssdk.services.cloud9.DefaultCloud9BaseClientBuilder;
import software.amazon.awssdk.services.cloud9.endpoints.Cloud9EndpointProvider;

@SdkInternalApi
final class DefaultCloud9AsyncClientBuilder
extends DefaultCloud9BaseClientBuilder<Cloud9AsyncClientBuilder, Cloud9AsyncClient>
implements Cloud9AsyncClientBuilder {
    DefaultCloud9AsyncClientBuilder() {
    }

    @Override
    public DefaultCloud9AsyncClientBuilder endpointProvider(Cloud9EndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final Cloud9AsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultCloud9AsyncClientBuilder.validateClientOptions(clientConfiguration);
        Cloud9ServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultCloud9AsyncClient client = new DefaultCloud9AsyncClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private Cloud9ServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        EndpointProvider endpointProvider = (EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER);
        if (clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return Cloud9ServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider(endpointProvider).build();
    }
}

