/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanroomsml.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.cleanroomsml.model.AudienceGenerationJobDataSource;
import software.amazon.awssdk.services.cleanroomsml.model.AudienceGenerationJobStatus;
import software.amazon.awssdk.services.cleanroomsml.model.AudienceQualityMetrics;
import software.amazon.awssdk.services.cleanroomsml.model.CleanRoomsMlResponse;
import software.amazon.awssdk.services.cleanroomsml.model.StatusDetails;
import software.amazon.awssdk.services.cleanroomsml.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetAudienceGenerationJobResponse
extends CleanRoomsMlResponse
implements ToCopyableBuilder<Builder, GetAudienceGenerationJobResponse> {
    private static final SdkField<String> AUDIENCE_GENERATION_JOB_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("audienceGenerationJobArn").getter(GetAudienceGenerationJobResponse.getter(GetAudienceGenerationJobResponse::audienceGenerationJobArn)).setter(GetAudienceGenerationJobResponse.setter(Builder::audienceGenerationJobArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("audienceGenerationJobArn").build()}).build();
    private static final SdkField<String> COLLABORATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("collaborationId").getter(GetAudienceGenerationJobResponse.getter(GetAudienceGenerationJobResponse::collaborationId)).setter(GetAudienceGenerationJobResponse.setter(Builder::collaborationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("collaborationId").build()}).build();
    private static final SdkField<String> CONFIGURED_AUDIENCE_MODEL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("configuredAudienceModelArn").getter(GetAudienceGenerationJobResponse.getter(GetAudienceGenerationJobResponse::configuredAudienceModelArn)).setter(GetAudienceGenerationJobResponse.setter(Builder::configuredAudienceModelArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configuredAudienceModelArn").build()}).build();
    private static final SdkField<Instant> CREATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createTime").getter(GetAudienceGenerationJobResponse.getter(GetAudienceGenerationJobResponse::createTime)).setter(GetAudienceGenerationJobResponse.setter(Builder::createTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(GetAudienceGenerationJobResponse.getter(GetAudienceGenerationJobResponse::description)).setter(GetAudienceGenerationJobResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<Boolean> INCLUDE_SEED_IN_OUTPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("includeSeedInOutput").getter(GetAudienceGenerationJobResponse.getter(GetAudienceGenerationJobResponse::includeSeedInOutput)).setter(GetAudienceGenerationJobResponse.setter(Builder::includeSeedInOutput)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("includeSeedInOutput").build()}).build();
    private static final SdkField<AudienceQualityMetrics> METRICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("metrics").getter(GetAudienceGenerationJobResponse.getter(GetAudienceGenerationJobResponse::metrics)).setter(GetAudienceGenerationJobResponse.setter(Builder::metrics)).constructor(AudienceQualityMetrics::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metrics").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(GetAudienceGenerationJobResponse.getter(GetAudienceGenerationJobResponse::name)).setter(GetAudienceGenerationJobResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<AudienceGenerationJobDataSource> SEED_AUDIENCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("seedAudience").getter(GetAudienceGenerationJobResponse.getter(GetAudienceGenerationJobResponse::seedAudience)).setter(GetAudienceGenerationJobResponse.setter(Builder::seedAudience)).constructor(AudienceGenerationJobDataSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("seedAudience").build()}).build();
    private static final SdkField<String> STARTED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("startedBy").getter(GetAudienceGenerationJobResponse.getter(GetAudienceGenerationJobResponse::startedBy)).setter(GetAudienceGenerationJobResponse.setter(Builder::startedBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startedBy").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(GetAudienceGenerationJobResponse.getter(GetAudienceGenerationJobResponse::statusAsString)).setter(GetAudienceGenerationJobResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<StatusDetails> STATUS_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("statusDetails").getter(GetAudienceGenerationJobResponse.getter(GetAudienceGenerationJobResponse::statusDetails)).setter(GetAudienceGenerationJobResponse.setter(Builder::statusDetails)).constructor(StatusDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusDetails").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(GetAudienceGenerationJobResponse.getter(GetAudienceGenerationJobResponse::tags)).setter(GetAudienceGenerationJobResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Instant> UPDATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("updateTime").getter(GetAudienceGenerationJobResponse.getter(GetAudienceGenerationJobResponse::updateTime)).setter(GetAudienceGenerationJobResponse.setter(Builder::updateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updateTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUDIENCE_GENERATION_JOB_ARN_FIELD, COLLABORATION_ID_FIELD, CONFIGURED_AUDIENCE_MODEL_ARN_FIELD, CREATE_TIME_FIELD, DESCRIPTION_FIELD, INCLUDE_SEED_IN_OUTPUT_FIELD, METRICS_FIELD, NAME_FIELD, SEED_AUDIENCE_FIELD, STARTED_BY_FIELD, STATUS_FIELD, STATUS_DETAILS_FIELD, TAGS_FIELD, UPDATE_TIME_FIELD));
    private final String audienceGenerationJobArn;
    private final String collaborationId;
    private final String configuredAudienceModelArn;
    private final Instant createTime;
    private final String description;
    private final Boolean includeSeedInOutput;
    private final AudienceQualityMetrics metrics;
    private final String name;
    private final AudienceGenerationJobDataSource seedAudience;
    private final String startedBy;
    private final String status;
    private final StatusDetails statusDetails;
    private final Map<String, String> tags;
    private final Instant updateTime;

    private GetAudienceGenerationJobResponse(BuilderImpl builder) {
        super(builder);
        this.audienceGenerationJobArn = builder.audienceGenerationJobArn;
        this.collaborationId = builder.collaborationId;
        this.configuredAudienceModelArn = builder.configuredAudienceModelArn;
        this.createTime = builder.createTime;
        this.description = builder.description;
        this.includeSeedInOutput = builder.includeSeedInOutput;
        this.metrics = builder.metrics;
        this.name = builder.name;
        this.seedAudience = builder.seedAudience;
        this.startedBy = builder.startedBy;
        this.status = builder.status;
        this.statusDetails = builder.statusDetails;
        this.tags = builder.tags;
        this.updateTime = builder.updateTime;
    }

    public final String audienceGenerationJobArn() {
        return this.audienceGenerationJobArn;
    }

    public final String collaborationId() {
        return this.collaborationId;
    }

    public final String configuredAudienceModelArn() {
        return this.configuredAudienceModelArn;
    }

    public final Instant createTime() {
        return this.createTime;
    }

    public final String description() {
        return this.description;
    }

    public final Boolean includeSeedInOutput() {
        return this.includeSeedInOutput;
    }

    public final AudienceQualityMetrics metrics() {
        return this.metrics;
    }

    public final String name() {
        return this.name;
    }

    public final AudienceGenerationJobDataSource seedAudience() {
        return this.seedAudience;
    }

    public final String startedBy() {
        return this.startedBy;
    }

    public final AudienceGenerationJobStatus status() {
        return AudienceGenerationJobStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final StatusDetails statusDetails() {
        return this.statusDetails;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final Instant updateTime() {
        return this.updateTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.audienceGenerationJobArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.collaborationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.configuredAudienceModelArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.createTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.includeSeedInOutput());
        hashCode = 31 * hashCode + Objects.hashCode(this.metrics());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.seedAudience());
        hashCode = 31 * hashCode + Objects.hashCode(this.startedBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.updateTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAudienceGenerationJobResponse)) {
            return false;
        }
        GetAudienceGenerationJobResponse other = (GetAudienceGenerationJobResponse)((Object)obj);
        return Objects.equals(this.audienceGenerationJobArn(), other.audienceGenerationJobArn()) && Objects.equals(this.collaborationId(), other.collaborationId()) && Objects.equals(this.configuredAudienceModelArn(), other.configuredAudienceModelArn()) && Objects.equals(this.createTime(), other.createTime()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.includeSeedInOutput(), other.includeSeedInOutput()) && Objects.equals(this.metrics(), other.metrics()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.seedAudience(), other.seedAudience()) && Objects.equals(this.startedBy(), other.startedBy()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusDetails(), other.statusDetails()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.updateTime(), other.updateTime());
    }

    public final String toString() {
        return ToString.builder((String)"GetAudienceGenerationJobResponse").add("AudienceGenerationJobArn", (Object)this.audienceGenerationJobArn()).add("CollaborationId", (Object)this.collaborationId()).add("ConfiguredAudienceModelArn", (Object)this.configuredAudienceModelArn()).add("CreateTime", (Object)this.createTime()).add("Description", (Object)this.description()).add("IncludeSeedInOutput", (Object)this.includeSeedInOutput()).add("Metrics", (Object)this.metrics()).add("Name", (Object)this.name()).add("SeedAudience", (Object)this.seedAudience()).add("StartedBy", (Object)this.startedBy()).add("Status", (Object)this.statusAsString()).add("StatusDetails", (Object)this.statusDetails()).add("Tags", this.hasTags() ? this.tags() : null).add("UpdateTime", (Object)this.updateTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "audienceGenerationJobArn": {
                return Optional.ofNullable(clazz.cast(this.audienceGenerationJobArn()));
            }
            case "collaborationId": {
                return Optional.ofNullable(clazz.cast(this.collaborationId()));
            }
            case "configuredAudienceModelArn": {
                return Optional.ofNullable(clazz.cast(this.configuredAudienceModelArn()));
            }
            case "createTime": {
                return Optional.ofNullable(clazz.cast(this.createTime()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "includeSeedInOutput": {
                return Optional.ofNullable(clazz.cast(this.includeSeedInOutput()));
            }
            case "metrics": {
                return Optional.ofNullable(clazz.cast(this.metrics()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "seedAudience": {
                return Optional.ofNullable(clazz.cast(this.seedAudience()));
            }
            case "startedBy": {
                return Optional.ofNullable(clazz.cast(this.startedBy()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "statusDetails": {
                return Optional.ofNullable(clazz.cast(this.statusDetails()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "updateTime": {
                return Optional.ofNullable(clazz.cast(this.updateTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetAudienceGenerationJobResponse, T> g) {
        return obj -> g.apply((GetAudienceGenerationJobResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CleanRoomsMlResponse.BuilderImpl
    implements Builder {
        private String audienceGenerationJobArn;
        private String collaborationId;
        private String configuredAudienceModelArn;
        private Instant createTime;
        private String description;
        private Boolean includeSeedInOutput;
        private AudienceQualityMetrics metrics;
        private String name;
        private AudienceGenerationJobDataSource seedAudience;
        private String startedBy;
        private String status;
        private StatusDetails statusDetails;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private Instant updateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(GetAudienceGenerationJobResponse model) {
            super(model);
            this.audienceGenerationJobArn(model.audienceGenerationJobArn);
            this.collaborationId(model.collaborationId);
            this.configuredAudienceModelArn(model.configuredAudienceModelArn);
            this.createTime(model.createTime);
            this.description(model.description);
            this.includeSeedInOutput(model.includeSeedInOutput);
            this.metrics(model.metrics);
            this.name(model.name);
            this.seedAudience(model.seedAudience);
            this.startedBy(model.startedBy);
            this.status(model.status);
            this.statusDetails(model.statusDetails);
            this.tags(model.tags);
            this.updateTime(model.updateTime);
        }

        public final String getAudienceGenerationJobArn() {
            return this.audienceGenerationJobArn;
        }

        public final void setAudienceGenerationJobArn(String audienceGenerationJobArn) {
            this.audienceGenerationJobArn = audienceGenerationJobArn;
        }

        @Override
        public final Builder audienceGenerationJobArn(String audienceGenerationJobArn) {
            this.audienceGenerationJobArn = audienceGenerationJobArn;
            return this;
        }

        public final String getCollaborationId() {
            return this.collaborationId;
        }

        public final void setCollaborationId(String collaborationId) {
            this.collaborationId = collaborationId;
        }

        @Override
        public final Builder collaborationId(String collaborationId) {
            this.collaborationId = collaborationId;
            return this;
        }

        public final String getConfiguredAudienceModelArn() {
            return this.configuredAudienceModelArn;
        }

        public final void setConfiguredAudienceModelArn(String configuredAudienceModelArn) {
            this.configuredAudienceModelArn = configuredAudienceModelArn;
        }

        @Override
        public final Builder configuredAudienceModelArn(String configuredAudienceModelArn) {
            this.configuredAudienceModelArn = configuredAudienceModelArn;
            return this;
        }

        public final Instant getCreateTime() {
            return this.createTime;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        @Override
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Boolean getIncludeSeedInOutput() {
            return this.includeSeedInOutput;
        }

        public final void setIncludeSeedInOutput(Boolean includeSeedInOutput) {
            this.includeSeedInOutput = includeSeedInOutput;
        }

        @Override
        public final Builder includeSeedInOutput(Boolean includeSeedInOutput) {
            this.includeSeedInOutput = includeSeedInOutput;
            return this;
        }

        public final AudienceQualityMetrics.Builder getMetrics() {
            return this.metrics != null ? this.metrics.toBuilder() : null;
        }

        public final void setMetrics(AudienceQualityMetrics.BuilderImpl metrics) {
            this.metrics = metrics != null ? metrics.build() : null;
        }

        @Override
        public final Builder metrics(AudienceQualityMetrics metrics) {
            this.metrics = metrics;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final AudienceGenerationJobDataSource.Builder getSeedAudience() {
            return this.seedAudience != null ? this.seedAudience.toBuilder() : null;
        }

        public final void setSeedAudience(AudienceGenerationJobDataSource.BuilderImpl seedAudience) {
            this.seedAudience = seedAudience != null ? seedAudience.build() : null;
        }

        @Override
        public final Builder seedAudience(AudienceGenerationJobDataSource seedAudience) {
            this.seedAudience = seedAudience;
            return this;
        }

        public final String getStartedBy() {
            return this.startedBy;
        }

        public final void setStartedBy(String startedBy) {
            this.startedBy = startedBy;
        }

        @Override
        public final Builder startedBy(String startedBy) {
            this.startedBy = startedBy;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(AudienceGenerationJobStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final StatusDetails.Builder getStatusDetails() {
            return this.statusDetails != null ? this.statusDetails.toBuilder() : null;
        }

        public final void setStatusDetails(StatusDetails.BuilderImpl statusDetails) {
            this.statusDetails = statusDetails != null ? statusDetails.build() : null;
        }

        @Override
        public final Builder statusDetails(StatusDetails statusDetails) {
            this.statusDetails = statusDetails;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final Instant getUpdateTime() {
            return this.updateTime;
        }

        public final void setUpdateTime(Instant updateTime) {
            this.updateTime = updateTime;
        }

        @Override
        public final Builder updateTime(Instant updateTime) {
            this.updateTime = updateTime;
            return this;
        }

        @Override
        public GetAudienceGenerationJobResponse build() {
            return new GetAudienceGenerationJobResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CleanRoomsMlResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetAudienceGenerationJobResponse> {
        public Builder audienceGenerationJobArn(String var1);

        public Builder collaborationId(String var1);

        public Builder configuredAudienceModelArn(String var1);

        public Builder createTime(Instant var1);

        public Builder description(String var1);

        public Builder includeSeedInOutput(Boolean var1);

        public Builder metrics(AudienceQualityMetrics var1);

        default public Builder metrics(Consumer<AudienceQualityMetrics.Builder> metrics) {
            return this.metrics((AudienceQualityMetrics)((AudienceQualityMetrics.Builder)AudienceQualityMetrics.builder().applyMutation(metrics)).build());
        }

        public Builder name(String var1);

        public Builder seedAudience(AudienceGenerationJobDataSource var1);

        default public Builder seedAudience(Consumer<AudienceGenerationJobDataSource.Builder> seedAudience) {
            return this.seedAudience((AudienceGenerationJobDataSource)((AudienceGenerationJobDataSource.Builder)AudienceGenerationJobDataSource.builder().applyMutation(seedAudience)).build());
        }

        public Builder startedBy(String var1);

        public Builder status(String var1);

        public Builder status(AudienceGenerationJobStatus var1);

        public Builder statusDetails(StatusDetails var1);

        default public Builder statusDetails(Consumer<StatusDetails.Builder> statusDetails) {
            return this.statusDetails((StatusDetails)((StatusDetails.Builder)StatusDetails.builder().applyMutation(statusDetails)).build());
        }

        public Builder tags(Map<String, String> var1);

        public Builder updateTime(Instant var1);
    }
}

