/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanrooms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains configurations for protected query results.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ProtectedQueryResultConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<ProtectedQueryResultConfiguration.Builder, ProtectedQueryResultConfiguration> {
    private static final SdkField<ProtectedQueryOutputConfiguration> OUTPUT_CONFIGURATION_FIELD = SdkField
            .<ProtectedQueryOutputConfiguration> builder(MarshallingType.SDK_POJO).memberName("outputConfiguration")
            .getter(getter(ProtectedQueryResultConfiguration::outputConfiguration)).setter(setter(Builder::outputConfiguration))
            .constructor(ProtectedQueryOutputConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OUTPUT_CONFIGURATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final ProtectedQueryOutputConfiguration outputConfiguration;

    private ProtectedQueryResultConfiguration(BuilderImpl builder) {
        this.outputConfiguration = builder.outputConfiguration;
    }

    /**
     * <p>
     * Configuration for protected query results.
     * </p>
     * 
     * @return Configuration for protected query results.
     */
    public final ProtectedQueryOutputConfiguration outputConfiguration() {
        return outputConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(outputConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProtectedQueryResultConfiguration)) {
            return false;
        }
        ProtectedQueryResultConfiguration other = (ProtectedQueryResultConfiguration) obj;
        return Objects.equals(outputConfiguration(), other.outputConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ProtectedQueryResultConfiguration").add("OutputConfiguration", outputConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "outputConfiguration":
            return Optional.ofNullable(clazz.cast(outputConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ProtectedQueryResultConfiguration, T> g) {
        return obj -> g.apply((ProtectedQueryResultConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ProtectedQueryResultConfiguration> {
        /**
         * <p>
         * Configuration for protected query results.
         * </p>
         * 
         * @param outputConfiguration
         *        Configuration for protected query results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputConfiguration(ProtectedQueryOutputConfiguration outputConfiguration);

        /**
         * <p>
         * Configuration for protected query results.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ProtectedQueryOutputConfiguration.Builder} avoiding the need to create one manually via
         * {@link ProtectedQueryOutputConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ProtectedQueryOutputConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #outputConfiguration(ProtectedQueryOutputConfiguration)}.
         * 
         * @param outputConfiguration
         *        a consumer that will call methods on {@link ProtectedQueryOutputConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #outputConfiguration(ProtectedQueryOutputConfiguration)
         */
        default Builder outputConfiguration(Consumer<ProtectedQueryOutputConfiguration.Builder> outputConfiguration) {
            return outputConfiguration(ProtectedQueryOutputConfiguration.builder().applyMutation(outputConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ProtectedQueryOutputConfiguration outputConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(ProtectedQueryResultConfiguration model) {
            outputConfiguration(model.outputConfiguration);
        }

        public final ProtectedQueryOutputConfiguration.Builder getOutputConfiguration() {
            return outputConfiguration != null ? outputConfiguration.toBuilder() : null;
        }

        public final void setOutputConfiguration(ProtectedQueryOutputConfiguration.BuilderImpl outputConfiguration) {
            this.outputConfiguration = outputConfiguration != null ? outputConfiguration.build() : null;
        }

        @Override
        public final Builder outputConfiguration(ProtectedQueryOutputConfiguration outputConfiguration) {
            this.outputConfiguration = outputConfiguration;
            return this;
        }

        @Override
        public ProtectedQueryResultConfiguration build() {
            return new ProtectedQueryResultConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
