/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanrooms.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateConfiguredTableAnalysisRuleRequest extends CleanRoomsRequest implements
        ToCopyableBuilder<CreateConfiguredTableAnalysisRuleRequest.Builder, CreateConfiguredTableAnalysisRuleRequest> {
    private static final SdkField<String> CONFIGURED_TABLE_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("configuredTableIdentifier")
            .getter(getter(CreateConfiguredTableAnalysisRuleRequest::configuredTableIdentifier))
            .setter(setter(Builder::configuredTableIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("configuredTableIdentifier").build())
            .build();

    private static final SdkField<String> ANALYSIS_RULE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("analysisRuleType").getter(getter(CreateConfiguredTableAnalysisRuleRequest::analysisRuleTypeAsString))
            .setter(setter(Builder::analysisRuleType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("analysisRuleType").build()).build();

    private static final SdkField<ConfiguredTableAnalysisRulePolicy> ANALYSIS_RULE_POLICY_FIELD = SdkField
            .<ConfiguredTableAnalysisRulePolicy> builder(MarshallingType.SDK_POJO).memberName("analysisRulePolicy")
            .getter(getter(CreateConfiguredTableAnalysisRuleRequest::analysisRulePolicy))
            .setter(setter(Builder::analysisRulePolicy)).constructor(ConfiguredTableAnalysisRulePolicy::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("analysisRulePolicy").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CONFIGURED_TABLE_IDENTIFIER_FIELD, ANALYSIS_RULE_TYPE_FIELD, ANALYSIS_RULE_POLICY_FIELD));

    private final String configuredTableIdentifier;

    private final String analysisRuleType;

    private final ConfiguredTableAnalysisRulePolicy analysisRulePolicy;

    private CreateConfiguredTableAnalysisRuleRequest(BuilderImpl builder) {
        super(builder);
        this.configuredTableIdentifier = builder.configuredTableIdentifier;
        this.analysisRuleType = builder.analysisRuleType;
        this.analysisRulePolicy = builder.analysisRulePolicy;
    }

    /**
     * <p>
     * The identifier for the configured table to create the analysis rule for. Currently accepts the configured table
     * ID.
     * </p>
     * 
     * @return The identifier for the configured table to create the analysis rule for. Currently accepts the configured
     *         table ID.
     */
    public final String configuredTableIdentifier() {
        return configuredTableIdentifier;
    }

    /**
     * <p>
     * The type of analysis rule. Valid values are AGGREGATION and LIST.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #analysisRuleType}
     * will return {@link ConfiguredTableAnalysisRuleType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #analysisRuleTypeAsString}.
     * </p>
     * 
     * @return The type of analysis rule. Valid values are AGGREGATION and LIST.
     * @see ConfiguredTableAnalysisRuleType
     */
    public final ConfiguredTableAnalysisRuleType analysisRuleType() {
        return ConfiguredTableAnalysisRuleType.fromValue(analysisRuleType);
    }

    /**
     * <p>
     * The type of analysis rule. Valid values are AGGREGATION and LIST.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #analysisRuleType}
     * will return {@link ConfiguredTableAnalysisRuleType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #analysisRuleTypeAsString}.
     * </p>
     * 
     * @return The type of analysis rule. Valid values are AGGREGATION and LIST.
     * @see ConfiguredTableAnalysisRuleType
     */
    public final String analysisRuleTypeAsString() {
        return analysisRuleType;
    }

    /**
     * <p>
     * The entire created configured table analysis rule object.
     * </p>
     * 
     * @return The entire created configured table analysis rule object.
     */
    public final ConfiguredTableAnalysisRulePolicy analysisRulePolicy() {
        return analysisRulePolicy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(configuredTableIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(analysisRuleTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(analysisRulePolicy());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateConfiguredTableAnalysisRuleRequest)) {
            return false;
        }
        CreateConfiguredTableAnalysisRuleRequest other = (CreateConfiguredTableAnalysisRuleRequest) obj;
        return Objects.equals(configuredTableIdentifier(), other.configuredTableIdentifier())
                && Objects.equals(analysisRuleTypeAsString(), other.analysisRuleTypeAsString())
                && Objects.equals(analysisRulePolicy(), other.analysisRulePolicy());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateConfiguredTableAnalysisRuleRequest")
                .add("ConfiguredTableIdentifier", configuredTableIdentifier())
                .add("AnalysisRuleType", analysisRuleTypeAsString()).add("AnalysisRulePolicy", analysisRulePolicy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "configuredTableIdentifier":
            return Optional.ofNullable(clazz.cast(configuredTableIdentifier()));
        case "analysisRuleType":
            return Optional.ofNullable(clazz.cast(analysisRuleTypeAsString()));
        case "analysisRulePolicy":
            return Optional.ofNullable(clazz.cast(analysisRulePolicy()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateConfiguredTableAnalysisRuleRequest, T> g) {
        return obj -> g.apply((CreateConfiguredTableAnalysisRuleRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CleanRoomsRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateConfiguredTableAnalysisRuleRequest> {
        /**
         * <p>
         * The identifier for the configured table to create the analysis rule for. Currently accepts the configured
         * table ID.
         * </p>
         * 
         * @param configuredTableIdentifier
         *        The identifier for the configured table to create the analysis rule for. Currently accepts the
         *        configured table ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configuredTableIdentifier(String configuredTableIdentifier);

        /**
         * <p>
         * The type of analysis rule. Valid values are AGGREGATION and LIST.
         * </p>
         * 
         * @param analysisRuleType
         *        The type of analysis rule. Valid values are AGGREGATION and LIST.
         * @see ConfiguredTableAnalysisRuleType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConfiguredTableAnalysisRuleType
         */
        Builder analysisRuleType(String analysisRuleType);

        /**
         * <p>
         * The type of analysis rule. Valid values are AGGREGATION and LIST.
         * </p>
         * 
         * @param analysisRuleType
         *        The type of analysis rule. Valid values are AGGREGATION and LIST.
         * @see ConfiguredTableAnalysisRuleType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConfiguredTableAnalysisRuleType
         */
        Builder analysisRuleType(ConfiguredTableAnalysisRuleType analysisRuleType);

        /**
         * <p>
         * The entire created configured table analysis rule object.
         * </p>
         * 
         * @param analysisRulePolicy
         *        The entire created configured table analysis rule object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder analysisRulePolicy(ConfiguredTableAnalysisRulePolicy analysisRulePolicy);

        /**
         * <p>
         * The entire created configured table analysis rule object.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ConfiguredTableAnalysisRulePolicy.Builder} avoiding the need to create one manually via
         * {@link ConfiguredTableAnalysisRulePolicy#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ConfiguredTableAnalysisRulePolicy.Builder#build()} is called
         * immediately and its result is passed to {@link #analysisRulePolicy(ConfiguredTableAnalysisRulePolicy)}.
         * 
         * @param analysisRulePolicy
         *        a consumer that will call methods on {@link ConfiguredTableAnalysisRulePolicy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #analysisRulePolicy(ConfiguredTableAnalysisRulePolicy)
         */
        default Builder analysisRulePolicy(Consumer<ConfiguredTableAnalysisRulePolicy.Builder> analysisRulePolicy) {
            return analysisRulePolicy(ConfiguredTableAnalysisRulePolicy.builder().applyMutation(analysisRulePolicy).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CleanRoomsRequest.BuilderImpl implements Builder {
        private String configuredTableIdentifier;

        private String analysisRuleType;

        private ConfiguredTableAnalysisRulePolicy analysisRulePolicy;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateConfiguredTableAnalysisRuleRequest model) {
            super(model);
            configuredTableIdentifier(model.configuredTableIdentifier);
            analysisRuleType(model.analysisRuleType);
            analysisRulePolicy(model.analysisRulePolicy);
        }

        public final String getConfiguredTableIdentifier() {
            return configuredTableIdentifier;
        }

        public final void setConfiguredTableIdentifier(String configuredTableIdentifier) {
            this.configuredTableIdentifier = configuredTableIdentifier;
        }

        @Override
        public final Builder configuredTableIdentifier(String configuredTableIdentifier) {
            this.configuredTableIdentifier = configuredTableIdentifier;
            return this;
        }

        public final String getAnalysisRuleType() {
            return analysisRuleType;
        }

        public final void setAnalysisRuleType(String analysisRuleType) {
            this.analysisRuleType = analysisRuleType;
        }

        @Override
        public final Builder analysisRuleType(String analysisRuleType) {
            this.analysisRuleType = analysisRuleType;
            return this;
        }

        @Override
        public final Builder analysisRuleType(ConfiguredTableAnalysisRuleType analysisRuleType) {
            this.analysisRuleType(analysisRuleType == null ? null : analysisRuleType.toString());
            return this;
        }

        public final ConfiguredTableAnalysisRulePolicy.Builder getAnalysisRulePolicy() {
            return analysisRulePolicy != null ? analysisRulePolicy.toBuilder() : null;
        }

        public final void setAnalysisRulePolicy(ConfiguredTableAnalysisRulePolicy.BuilderImpl analysisRulePolicy) {
            this.analysisRulePolicy = analysisRulePolicy != null ? analysisRulePolicy.build() : null;
        }

        @Override
        public final Builder analysisRulePolicy(ConfiguredTableAnalysisRulePolicy analysisRulePolicy) {
            this.analysisRulePolicy = analysisRulePolicy;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateConfiguredTableAnalysisRuleRequest build() {
            return new CreateConfiguredTableAnalysisRuleRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
