/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanrooms.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cleanrooms.CleanRoomsClient;
import software.amazon.awssdk.services.cleanrooms.internal.UserAgentUtils;
import software.amazon.awssdk.services.cleanrooms.model.AnalysisTemplateSummary;
import software.amazon.awssdk.services.cleanrooms.model.ListAnalysisTemplatesRequest;
import software.amazon.awssdk.services.cleanrooms.model.ListAnalysisTemplatesResponse;

public class ListAnalysisTemplatesIterable
implements SdkIterable<ListAnalysisTemplatesResponse> {
    private final CleanRoomsClient client;
    private final ListAnalysisTemplatesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListAnalysisTemplatesIterable(CleanRoomsClient client, ListAnalysisTemplatesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListAnalysisTemplatesResponseFetcher();
    }

    public Iterator<ListAnalysisTemplatesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<AnalysisTemplateSummary> analysisTemplateSummaries() {
        Function<ListAnalysisTemplatesResponse, Iterator> getIterator = response -> {
            if (response != null && response.analysisTemplateSummaries() != null) {
                return response.analysisTemplateSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListAnalysisTemplatesResponseFetcher
    implements SyncPageFetcher<ListAnalysisTemplatesResponse> {
        private ListAnalysisTemplatesResponseFetcher() {
        }

        public boolean hasNextPage(ListAnalysisTemplatesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListAnalysisTemplatesResponse nextPage(ListAnalysisTemplatesResponse previousPage) {
            if (previousPage == null) {
                return ListAnalysisTemplatesIterable.this.client.listAnalysisTemplates(ListAnalysisTemplatesIterable.this.firstRequest);
            }
            return ListAnalysisTemplatesIterable.this.client.listAnalysisTemplates((ListAnalysisTemplatesRequest)((Object)ListAnalysisTemplatesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

