/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanrooms.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ResultFormat {
    CSV("CSV"),
    PARQUET("PARQUET"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ResultFormat> VALUE_MAP;
    private final String value;

    private ResultFormat(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ResultFormat fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ResultFormat> knownValues() {
        EnumSet<ResultFormat> knownValues = EnumSet.allOf(ResultFormat.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ResultFormat.class, ResultFormat::toString);
    }
}

