/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chimesdkidentity.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the type of message that triggers a bot.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InvokedBy implements SdkPojo, Serializable, ToCopyableBuilder<InvokedBy.Builder, InvokedBy> {
    private static final SdkField<String> STANDARD_MESSAGES_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StandardMessages").getter(getter(InvokedBy::standardMessagesAsString))
            .setter(setter(Builder::standardMessages))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StandardMessages").build()).build();

    private static final SdkField<String> TARGETED_MESSAGES_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TargetedMessages").getter(getter(InvokedBy::targetedMessagesAsString))
            .setter(setter(Builder::targetedMessages))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetedMessages").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STANDARD_MESSAGES_FIELD,
            TARGETED_MESSAGES_FIELD));

    private static final long serialVersionUID = 1L;

    private final String standardMessages;

    private final String targetedMessages;

    private InvokedBy(BuilderImpl builder) {
        this.standardMessages = builder.standardMessages;
        this.targetedMessages = builder.targetedMessages;
    }

    /**
     * <p>
     * Sets standard messages as the bot trigger. For standard messages:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ALL</code>: The bot processes all standard messages.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AUTO</code>: The bot responds to ALL messages when the channel has one other non-hidden member, and
     * responds to MENTIONS when the channel has more than one other non-hidden member.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>MENTIONS</code>: The bot processes all standard messages that have a message attribute with
     * <code>CHIME.mentions</code> and a value of the bot ARN.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NONE</code>: The bot processes no standard messages.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #standardMessages}
     * will return {@link StandardMessages#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #standardMessagesAsString}.
     * </p>
     * 
     * @return Sets standard messages as the bot trigger. For standard messages:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ALL</code>: The bot processes all standard messages.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AUTO</code>: The bot responds to ALL messages when the channel has one other non-hidden member, and
     *         responds to MENTIONS when the channel has more than one other non-hidden member.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>MENTIONS</code>: The bot processes all standard messages that have a message attribute with
     *         <code>CHIME.mentions</code> and a value of the bot ARN.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NONE</code>: The bot processes no standard messages.
     *         </p>
     *         </li>
     * @see StandardMessages
     */
    public final StandardMessages standardMessages() {
        return StandardMessages.fromValue(standardMessages);
    }

    /**
     * <p>
     * Sets standard messages as the bot trigger. For standard messages:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ALL</code>: The bot processes all standard messages.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AUTO</code>: The bot responds to ALL messages when the channel has one other non-hidden member, and
     * responds to MENTIONS when the channel has more than one other non-hidden member.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>MENTIONS</code>: The bot processes all standard messages that have a message attribute with
     * <code>CHIME.mentions</code> and a value of the bot ARN.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NONE</code>: The bot processes no standard messages.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #standardMessages}
     * will return {@link StandardMessages#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #standardMessagesAsString}.
     * </p>
     * 
     * @return Sets standard messages as the bot trigger. For standard messages:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ALL</code>: The bot processes all standard messages.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AUTO</code>: The bot responds to ALL messages when the channel has one other non-hidden member, and
     *         responds to MENTIONS when the channel has more than one other non-hidden member.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>MENTIONS</code>: The bot processes all standard messages that have a message attribute with
     *         <code>CHIME.mentions</code> and a value of the bot ARN.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NONE</code>: The bot processes no standard messages.
     *         </p>
     *         </li>
     * @see StandardMessages
     */
    public final String standardMessagesAsString() {
        return standardMessages;
    }

    /**
     * <p>
     * Sets targeted messages as the bot trigger. For targeted messages:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ALL</code>: The bot processes all <code>TargetedMessages</code> sent to it. The bot then responds with a
     * targeted message back to the sender.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NONE</code>: The bot processes no targeted messages.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #targetedMessages}
     * will return {@link TargetedMessages#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #targetedMessagesAsString}.
     * </p>
     * 
     * @return Sets targeted messages as the bot trigger. For targeted messages:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ALL</code>: The bot processes all <code>TargetedMessages</code> sent to it. The bot then responds
     *         with a targeted message back to the sender.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NONE</code>: The bot processes no targeted messages.
     *         </p>
     *         </li>
     * @see TargetedMessages
     */
    public final TargetedMessages targetedMessages() {
        return TargetedMessages.fromValue(targetedMessages);
    }

    /**
     * <p>
     * Sets targeted messages as the bot trigger. For targeted messages:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ALL</code>: The bot processes all <code>TargetedMessages</code> sent to it. The bot then responds with a
     * targeted message back to the sender.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NONE</code>: The bot processes no targeted messages.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #targetedMessages}
     * will return {@link TargetedMessages#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #targetedMessagesAsString}.
     * </p>
     * 
     * @return Sets targeted messages as the bot trigger. For targeted messages:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ALL</code>: The bot processes all <code>TargetedMessages</code> sent to it. The bot then responds
     *         with a targeted message back to the sender.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NONE</code>: The bot processes no targeted messages.
     *         </p>
     *         </li>
     * @see TargetedMessages
     */
    public final String targetedMessagesAsString() {
        return targetedMessages;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(standardMessagesAsString());
        hashCode = 31 * hashCode + Objects.hashCode(targetedMessagesAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InvokedBy)) {
            return false;
        }
        InvokedBy other = (InvokedBy) obj;
        return Objects.equals(standardMessagesAsString(), other.standardMessagesAsString())
                && Objects.equals(targetedMessagesAsString(), other.targetedMessagesAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InvokedBy").add("StandardMessages", standardMessagesAsString())
                .add("TargetedMessages", targetedMessagesAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StandardMessages":
            return Optional.ofNullable(clazz.cast(standardMessagesAsString()));
        case "TargetedMessages":
            return Optional.ofNullable(clazz.cast(targetedMessagesAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InvokedBy, T> g) {
        return obj -> g.apply((InvokedBy) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InvokedBy> {
        /**
         * <p>
         * Sets standard messages as the bot trigger. For standard messages:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ALL</code>: The bot processes all standard messages.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AUTO</code>: The bot responds to ALL messages when the channel has one other non-hidden member, and
         * responds to MENTIONS when the channel has more than one other non-hidden member.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>MENTIONS</code>: The bot processes all standard messages that have a message attribute with
         * <code>CHIME.mentions</code> and a value of the bot ARN.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NONE</code>: The bot processes no standard messages.
         * </p>
         * </li>
         * </ul>
         * 
         * @param standardMessages
         *        Sets standard messages as the bot trigger. For standard messages:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ALL</code>: The bot processes all standard messages.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AUTO</code>: The bot responds to ALL messages when the channel has one other non-hidden member,
         *        and responds to MENTIONS when the channel has more than one other non-hidden member.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>MENTIONS</code>: The bot processes all standard messages that have a message attribute with
         *        <code>CHIME.mentions</code> and a value of the bot ARN.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NONE</code>: The bot processes no standard messages.
         *        </p>
         *        </li>
         * @see StandardMessages
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StandardMessages
         */
        Builder standardMessages(String standardMessages);

        /**
         * <p>
         * Sets standard messages as the bot trigger. For standard messages:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ALL</code>: The bot processes all standard messages.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AUTO</code>: The bot responds to ALL messages when the channel has one other non-hidden member, and
         * responds to MENTIONS when the channel has more than one other non-hidden member.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>MENTIONS</code>: The bot processes all standard messages that have a message attribute with
         * <code>CHIME.mentions</code> and a value of the bot ARN.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NONE</code>: The bot processes no standard messages.
         * </p>
         * </li>
         * </ul>
         * 
         * @param standardMessages
         *        Sets standard messages as the bot trigger. For standard messages:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ALL</code>: The bot processes all standard messages.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AUTO</code>: The bot responds to ALL messages when the channel has one other non-hidden member,
         *        and responds to MENTIONS when the channel has more than one other non-hidden member.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>MENTIONS</code>: The bot processes all standard messages that have a message attribute with
         *        <code>CHIME.mentions</code> and a value of the bot ARN.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NONE</code>: The bot processes no standard messages.
         *        </p>
         *        </li>
         * @see StandardMessages
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StandardMessages
         */
        Builder standardMessages(StandardMessages standardMessages);

        /**
         * <p>
         * Sets targeted messages as the bot trigger. For targeted messages:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ALL</code>: The bot processes all <code>TargetedMessages</code> sent to it. The bot then responds with
         * a targeted message back to the sender.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NONE</code>: The bot processes no targeted messages.
         * </p>
         * </li>
         * </ul>
         * 
         * @param targetedMessages
         *        Sets targeted messages as the bot trigger. For targeted messages:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ALL</code>: The bot processes all <code>TargetedMessages</code> sent to it. The bot then
         *        responds with a targeted message back to the sender.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NONE</code>: The bot processes no targeted messages.
         *        </p>
         *        </li>
         * @see TargetedMessages
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TargetedMessages
         */
        Builder targetedMessages(String targetedMessages);

        /**
         * <p>
         * Sets targeted messages as the bot trigger. For targeted messages:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ALL</code>: The bot processes all <code>TargetedMessages</code> sent to it. The bot then responds with
         * a targeted message back to the sender.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NONE</code>: The bot processes no targeted messages.
         * </p>
         * </li>
         * </ul>
         * 
         * @param targetedMessages
         *        Sets targeted messages as the bot trigger. For targeted messages:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ALL</code>: The bot processes all <code>TargetedMessages</code> sent to it. The bot then
         *        responds with a targeted message back to the sender.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NONE</code>: The bot processes no targeted messages.
         *        </p>
         *        </li>
         * @see TargetedMessages
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TargetedMessages
         */
        Builder targetedMessages(TargetedMessages targetedMessages);
    }

    static final class BuilderImpl implements Builder {
        private String standardMessages;

        private String targetedMessages;

        private BuilderImpl() {
        }

        private BuilderImpl(InvokedBy model) {
            standardMessages(model.standardMessages);
            targetedMessages(model.targetedMessages);
        }

        public final String getStandardMessages() {
            return standardMessages;
        }

        public final void setStandardMessages(String standardMessages) {
            this.standardMessages = standardMessages;
        }

        @Override
        public final Builder standardMessages(String standardMessages) {
            this.standardMessages = standardMessages;
            return this;
        }

        @Override
        public final Builder standardMessages(StandardMessages standardMessages) {
            this.standardMessages(standardMessages == null ? null : standardMessages.toString());
            return this;
        }

        public final String getTargetedMessages() {
            return targetedMessages;
        }

        public final void setTargetedMessages(String targetedMessages) {
            this.targetedMessages = targetedMessages;
        }

        @Override
        public final Builder targetedMessages(String targetedMessages) {
            this.targetedMessages = targetedMessages;
            return this;
        }

        @Override
        public final Builder targetedMessages(TargetedMessages targetedMessages) {
            this.targetedMessages(targetedMessages == null ? null : targetedMessages.toString());
            return this;
        }

        @Override
        public InvokedBy build() {
            return new InvokedBy(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
