/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chime.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.chime.ChimeAsyncClient;
import software.amazon.awssdk.services.chime.internal.UserAgentUtils;
import software.amazon.awssdk.services.chime.model.ListSipRulesRequest;
import software.amazon.awssdk.services.chime.model.ListSipRulesResponse;

public class ListSipRulesPublisher
implements SdkPublisher<ListSipRulesResponse> {
    private final ChimeAsyncClient client;
    private final ListSipRulesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListSipRulesPublisher(ChimeAsyncClient client, ListSipRulesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListSipRulesPublisher(ChimeAsyncClient client, ListSipRulesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListSipRulesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListSipRulesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListSipRulesResponseFetcher
    implements AsyncPageFetcher<ListSipRulesResponse> {
        private ListSipRulesResponseFetcher() {
        }

        public boolean hasNextPage(ListSipRulesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListSipRulesResponse> nextPage(ListSipRulesResponse previousPage) {
            if (previousPage == null) {
                return ListSipRulesPublisher.this.client.listSipRules(ListSipRulesPublisher.this.firstRequest);
            }
            return ListSipRulesPublisher.this.client.listSipRules((ListSipRulesRequest)((Object)ListSipRulesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

