/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chime.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.chime.ChimeClient;
import software.amazon.awssdk.services.chime.internal.UserAgentUtils;
import software.amazon.awssdk.services.chime.model.ListRoomMembershipsRequest;
import software.amazon.awssdk.services.chime.model.ListRoomMembershipsResponse;

public class ListRoomMembershipsIterable
implements SdkIterable<ListRoomMembershipsResponse> {
    private final ChimeClient client;
    private final ListRoomMembershipsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListRoomMembershipsIterable(ChimeClient client, ListRoomMembershipsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListRoomMembershipsResponseFetcher();
    }

    public Iterator<ListRoomMembershipsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListRoomMembershipsResponseFetcher
    implements SyncPageFetcher<ListRoomMembershipsResponse> {
        private ListRoomMembershipsResponseFetcher() {
        }

        public boolean hasNextPage(ListRoomMembershipsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListRoomMembershipsResponse nextPage(ListRoomMembershipsResponse previousPage) {
            if (previousPage == null) {
                return ListRoomMembershipsIterable.this.client.listRoomMemberships(ListRoomMembershipsIterable.this.firstRequest);
            }
            return ListRoomMembershipsIterable.this.client.listRoomMemberships((ListRoomMembershipsRequest)((Object)ListRoomMembershipsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

