/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chime.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.chime.ChimeClient;
import software.amazon.awssdk.services.chime.model.ListAttendeesRequest;
import software.amazon.awssdk.services.chime.model.ListAttendeesResponse;

public class ListAttendeesIterable
implements SdkIterable<ListAttendeesResponse> {
    private final ChimeClient client;
    private final ListAttendeesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListAttendeesIterable(ChimeClient client, ListAttendeesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListAttendeesResponseFetcher();
    }

    public Iterator<ListAttendeesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListAttendeesResponseFetcher
    implements SyncPageFetcher<ListAttendeesResponse> {
        private ListAttendeesResponseFetcher() {
        }

        public boolean hasNextPage(ListAttendeesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListAttendeesResponse nextPage(ListAttendeesResponse previousPage) {
            if (previousPage == null) {
                return ListAttendeesIterable.this.client.listAttendees(ListAttendeesIterable.this.firstRequest);
            }
            return ListAttendeesIterable.this.client.listAttendees((ListAttendeesRequest)((Object)ListAttendeesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

