/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chime.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.chime.ChimeAsyncClient;
import software.amazon.awssdk.services.chime.model.ListAppInstancesRequest;
import software.amazon.awssdk.services.chime.model.ListAppInstancesResponse;

public class ListAppInstancesPublisher
implements SdkPublisher<ListAppInstancesResponse> {
    private final ChimeAsyncClient client;
    private final ListAppInstancesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListAppInstancesPublisher(ChimeAsyncClient client, ListAppInstancesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListAppInstancesPublisher(ChimeAsyncClient client, ListAppInstancesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListAppInstancesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListAppInstancesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListAppInstancesResponseFetcher
    implements AsyncPageFetcher<ListAppInstancesResponse> {
        private ListAppInstancesResponseFetcher() {
        }

        public boolean hasNextPage(ListAppInstancesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListAppInstancesResponse> nextPage(ListAppInstancesResponse previousPage) {
            if (previousPage == null) {
                return ListAppInstancesPublisher.this.client.listAppInstances(ListAppInstancesPublisher.this.firstRequest);
            }
            return ListAppInstancesPublisher.this.client.listAppInstances((ListAppInstancesRequest)((Object)ListAppInstancesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

