/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chime.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.chime.ChimeClient;
import software.amazon.awssdk.services.chime.model.ListSipMediaApplicationsRequest;
import software.amazon.awssdk.services.chime.model.ListSipMediaApplicationsResponse;

public class ListSipMediaApplicationsIterable
implements SdkIterable<ListSipMediaApplicationsResponse> {
    private final ChimeClient client;
    private final ListSipMediaApplicationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListSipMediaApplicationsIterable(ChimeClient client, ListSipMediaApplicationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListSipMediaApplicationsResponseFetcher();
    }

    public Iterator<ListSipMediaApplicationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListSipMediaApplicationsResponseFetcher
    implements SyncPageFetcher<ListSipMediaApplicationsResponse> {
        private ListSipMediaApplicationsResponseFetcher() {
        }

        public boolean hasNextPage(ListSipMediaApplicationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListSipMediaApplicationsResponse nextPage(ListSipMediaApplicationsResponse previousPage) {
            if (previousPage == null) {
                return ListSipMediaApplicationsIterable.this.client.listSipMediaApplications(ListSipMediaApplicationsIterable.this.firstRequest);
            }
            return ListSipMediaApplicationsIterable.this.client.listSipMediaApplications((ListSipMediaApplicationsRequest)((Object)ListSipMediaApplicationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

