/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.budgets.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.budgets.BudgetsAsyncClient;
import software.amazon.awssdk.services.budgets.model.ActionHistory;
import software.amazon.awssdk.services.budgets.model.DescribeBudgetActionHistoriesRequest;
import software.amazon.awssdk.services.budgets.model.DescribeBudgetActionHistoriesResponse;

public class DescribeBudgetActionHistoriesPublisher
implements SdkPublisher<DescribeBudgetActionHistoriesResponse> {
    private final BudgetsAsyncClient client;
    private final DescribeBudgetActionHistoriesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeBudgetActionHistoriesPublisher(BudgetsAsyncClient client, DescribeBudgetActionHistoriesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeBudgetActionHistoriesPublisher(BudgetsAsyncClient client, DescribeBudgetActionHistoriesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeBudgetActionHistoriesResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeBudgetActionHistoriesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ActionHistory> actionHistories() {
        Function<DescribeBudgetActionHistoriesResponse, Iterator> getIterator = response -> {
            if (response != null && response.actionHistories() != null) {
                return response.actionHistories().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeBudgetActionHistoriesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeBudgetActionHistoriesResponseFetcher
    implements AsyncPageFetcher<DescribeBudgetActionHistoriesResponse> {
        private DescribeBudgetActionHistoriesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeBudgetActionHistoriesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeBudgetActionHistoriesResponse> nextPage(DescribeBudgetActionHistoriesResponse previousPage) {
            if (previousPage == null) {
                return DescribeBudgetActionHistoriesPublisher.this.client.describeBudgetActionHistories(DescribeBudgetActionHistoriesPublisher.this.firstRequest);
            }
            return DescribeBudgetActionHistoriesPublisher.this.client.describeBudgetActionHistories((DescribeBudgetActionHistoriesRequest)((Object)DescribeBudgetActionHistoriesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

