/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.braket.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class JobCheckpointConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, JobCheckpointConfig> {
    private static final SdkField<String> LOCAL_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("localPath").getter(JobCheckpointConfig.getter(JobCheckpointConfig::localPath)).setter(JobCheckpointConfig.setter(Builder::localPath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("localPath").build()}).build();
    private static final SdkField<String> S3_URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("s3Uri").getter(JobCheckpointConfig.getter(JobCheckpointConfig::s3Uri)).setter(JobCheckpointConfig.setter(Builder::s3Uri)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3Uri").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOCAL_PATH_FIELD, S3_URI_FIELD));
    private static final long serialVersionUID = 1L;
    private final String localPath;
    private final String s3Uri;

    private JobCheckpointConfig(BuilderImpl builder) {
        this.localPath = builder.localPath;
        this.s3Uri = builder.s3Uri;
    }

    public final String localPath() {
        return this.localPath;
    }

    public final String s3Uri() {
        return this.s3Uri;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.localPath());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3Uri());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobCheckpointConfig)) {
            return false;
        }
        JobCheckpointConfig other = (JobCheckpointConfig)obj;
        return Objects.equals(this.localPath(), other.localPath()) && Objects.equals(this.s3Uri(), other.s3Uri());
    }

    public final String toString() {
        return ToString.builder((String)"JobCheckpointConfig").add("LocalPath", (Object)this.localPath()).add("S3Uri", (Object)this.s3Uri()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "localPath": {
                return Optional.ofNullable(clazz.cast(this.localPath()));
            }
            case "s3Uri": {
                return Optional.ofNullable(clazz.cast(this.s3Uri()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<JobCheckpointConfig, T> g) {
        return obj -> g.apply((JobCheckpointConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String localPath;
        private String s3Uri;

        private BuilderImpl() {
        }

        private BuilderImpl(JobCheckpointConfig model) {
            this.localPath(model.localPath);
            this.s3Uri(model.s3Uri);
        }

        public final String getLocalPath() {
            return this.localPath;
        }

        public final void setLocalPath(String localPath) {
            this.localPath = localPath;
        }

        @Override
        public final Builder localPath(String localPath) {
            this.localPath = localPath;
            return this;
        }

        public final String getS3Uri() {
            return this.s3Uri;
        }

        public final void setS3Uri(String s3Uri) {
            this.s3Uri = s3Uri;
        }

        @Override
        public final Builder s3Uri(String s3Uri) {
            this.s3Uri = s3Uri;
            return this;
        }

        public JobCheckpointConfig build() {
            return new JobCheckpointConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, JobCheckpointConfig> {
        public Builder localPath(String var1);

        public Builder s3Uri(String var1);
    }
}

