/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.billingconductor.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.billingconductor.model.CustomLineItemRelationship;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListResourcesAssociatedToCustomLineItemResponseElement
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ListResourcesAssociatedToCustomLineItemResponseElement> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(ListResourcesAssociatedToCustomLineItemResponseElement.getter(ListResourcesAssociatedToCustomLineItemResponseElement::arn)).setter(ListResourcesAssociatedToCustomLineItemResponseElement.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<String> RELATIONSHIP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Relationship").getter(ListResourcesAssociatedToCustomLineItemResponseElement.getter(ListResourcesAssociatedToCustomLineItemResponseElement::relationshipAsString)).setter(ListResourcesAssociatedToCustomLineItemResponseElement.setter(Builder::relationship)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Relationship").build()}).build();
    private static final SdkField<String> END_BILLING_PERIOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EndBillingPeriod").getter(ListResourcesAssociatedToCustomLineItemResponseElement.getter(ListResourcesAssociatedToCustomLineItemResponseElement::endBillingPeriod)).setter(ListResourcesAssociatedToCustomLineItemResponseElement.setter(Builder::endBillingPeriod)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndBillingPeriod").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, RELATIONSHIP_FIELD, END_BILLING_PERIOD_FIELD));
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final String relationship;
    private final String endBillingPeriod;

    private ListResourcesAssociatedToCustomLineItemResponseElement(BuilderImpl builder) {
        this.arn = builder.arn;
        this.relationship = builder.relationship;
        this.endBillingPeriod = builder.endBillingPeriod;
    }

    public final String arn() {
        return this.arn;
    }

    public final CustomLineItemRelationship relationship() {
        return CustomLineItemRelationship.fromValue(this.relationship);
    }

    public final String relationshipAsString() {
        return this.relationship;
    }

    public final String endBillingPeriod() {
        return this.endBillingPeriod;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.relationshipAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.endBillingPeriod());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListResourcesAssociatedToCustomLineItemResponseElement)) {
            return false;
        }
        ListResourcesAssociatedToCustomLineItemResponseElement other = (ListResourcesAssociatedToCustomLineItemResponseElement)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.relationshipAsString(), other.relationshipAsString()) && Objects.equals(this.endBillingPeriod(), other.endBillingPeriod());
    }

    public final String toString() {
        return ToString.builder((String)"ListResourcesAssociatedToCustomLineItemResponseElement").add("Arn", (Object)this.arn()).add("Relationship", (Object)this.relationshipAsString()).add("EndBillingPeriod", (Object)this.endBillingPeriod()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "Relationship": {
                return Optional.ofNullable(clazz.cast(this.relationshipAsString()));
            }
            case "EndBillingPeriod": {
                return Optional.ofNullable(clazz.cast(this.endBillingPeriod()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListResourcesAssociatedToCustomLineItemResponseElement, T> g) {
        return obj -> g.apply((ListResourcesAssociatedToCustomLineItemResponseElement)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private String relationship;
        private String endBillingPeriod;

        private BuilderImpl() {
        }

        private BuilderImpl(ListResourcesAssociatedToCustomLineItemResponseElement model) {
            this.arn(model.arn);
            this.relationship(model.relationship);
            this.endBillingPeriod(model.endBillingPeriod);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getRelationship() {
            return this.relationship;
        }

        public final void setRelationship(String relationship) {
            this.relationship = relationship;
        }

        @Override
        public final Builder relationship(String relationship) {
            this.relationship = relationship;
            return this;
        }

        @Override
        public final Builder relationship(CustomLineItemRelationship relationship) {
            this.relationship(relationship == null ? null : relationship.toString());
            return this;
        }

        public final String getEndBillingPeriod() {
            return this.endBillingPeriod;
        }

        public final void setEndBillingPeriod(String endBillingPeriod) {
            this.endBillingPeriod = endBillingPeriod;
        }

        @Override
        public final Builder endBillingPeriod(String endBillingPeriod) {
            this.endBillingPeriod = endBillingPeriod;
            return this;
        }

        public ListResourcesAssociatedToCustomLineItemResponseElement build() {
            return new ListResourcesAssociatedToCustomLineItemResponseElement(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ListResourcesAssociatedToCustomLineItemResponseElement> {
        public Builder arn(String var1);

        public Builder relationship(String var1);

        public Builder relationship(CustomLineItemRelationship var1);

        public Builder endBillingPeriod(String var1);
    }
}

