/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.billingconductor.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.billingconductor.BillingconductorAsyncClient;
import software.amazon.awssdk.services.billingconductor.model.ListPricingRulesRequest;
import software.amazon.awssdk.services.billingconductor.model.ListPricingRulesResponse;
import software.amazon.awssdk.services.billingconductor.model.PricingRuleListElement;

public class ListPricingRulesPublisher
implements SdkPublisher<ListPricingRulesResponse> {
    private final BillingconductorAsyncClient client;
    private final ListPricingRulesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListPricingRulesPublisher(BillingconductorAsyncClient client, ListPricingRulesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListPricingRulesPublisher(BillingconductorAsyncClient client, ListPricingRulesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListPricingRulesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListPricingRulesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<PricingRuleListElement> pricingRules() {
        Function<ListPricingRulesResponse, Iterator> getIterator = response -> {
            if (response != null && response.pricingRules() != null) {
                return response.pricingRules().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListPricingRulesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListPricingRulesResponseFetcher
    implements AsyncPageFetcher<ListPricingRulesResponse> {
        private ListPricingRulesResponseFetcher() {
        }

        public boolean hasNextPage(ListPricingRulesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListPricingRulesResponse> nextPage(ListPricingRulesResponse previousPage) {
            if (previousPage == null) {
                return ListPricingRulesPublisher.this.client.listPricingRules(ListPricingRulesPublisher.this.firstRequest);
            }
            return ListPricingRulesPublisher.this.client.listPricingRules((ListPricingRulesRequest)((Object)ListPricingRulesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

