/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.billingconductor.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.billingconductor.model.CustomLineItemRelationship;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListResourcesAssociatedToCustomLineItemFilter
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ListResourcesAssociatedToCustomLineItemFilter> {
    private static final SdkField<String> RELATIONSHIP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Relationship").getter(ListResourcesAssociatedToCustomLineItemFilter.getter(ListResourcesAssociatedToCustomLineItemFilter::relationshipAsString)).setter(ListResourcesAssociatedToCustomLineItemFilter.setter(Builder::relationship)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Relationship").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RELATIONSHIP_FIELD));
    private static final long serialVersionUID = 1L;
    private final String relationship;

    private ListResourcesAssociatedToCustomLineItemFilter(BuilderImpl builder) {
        this.relationship = builder.relationship;
    }

    public final CustomLineItemRelationship relationship() {
        return CustomLineItemRelationship.fromValue(this.relationship);
    }

    public final String relationshipAsString() {
        return this.relationship;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.relationshipAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListResourcesAssociatedToCustomLineItemFilter)) {
            return false;
        }
        ListResourcesAssociatedToCustomLineItemFilter other = (ListResourcesAssociatedToCustomLineItemFilter)obj;
        return Objects.equals(this.relationshipAsString(), other.relationshipAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ListResourcesAssociatedToCustomLineItemFilter").add("Relationship", (Object)this.relationshipAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Relationship": {
                return Optional.ofNullable(clazz.cast(this.relationshipAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListResourcesAssociatedToCustomLineItemFilter, T> g) {
        return obj -> g.apply((ListResourcesAssociatedToCustomLineItemFilter)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String relationship;

        private BuilderImpl() {
        }

        private BuilderImpl(ListResourcesAssociatedToCustomLineItemFilter model) {
            this.relationship(model.relationship);
        }

        public final String getRelationship() {
            return this.relationship;
        }

        public final void setRelationship(String relationship) {
            this.relationship = relationship;
        }

        @Override
        public final Builder relationship(String relationship) {
            this.relationship = relationship;
            return this;
        }

        @Override
        public final Builder relationship(CustomLineItemRelationship relationship) {
            this.relationship(relationship == null ? null : relationship.toString());
            return this;
        }

        public ListResourcesAssociatedToCustomLineItemFilter build() {
            return new ListResourcesAssociatedToCustomLineItemFilter(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ListResourcesAssociatedToCustomLineItemFilter> {
        public Builder relationship(String var1);

        public Builder relationship(CustomLineItemRelationship var1);
    }
}

