/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.billingconductor.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.billingconductor.model.BillingconductorRequest;
import software.amazon.awssdk.services.billingconductor.model.CustomLineItemBillingPeriodRange;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteCustomLineItemRequest
extends BillingconductorRequest
implements ToCopyableBuilder<Builder, DeleteCustomLineItemRequest> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(DeleteCustomLineItemRequest.getter(DeleteCustomLineItemRequest::arn)).setter(DeleteCustomLineItemRequest.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<CustomLineItemBillingPeriodRange> BILLING_PERIOD_RANGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("BillingPeriodRange").getter(DeleteCustomLineItemRequest.getter(DeleteCustomLineItemRequest::billingPeriodRange)).setter(DeleteCustomLineItemRequest.setter(Builder::billingPeriodRange)).constructor(CustomLineItemBillingPeriodRange::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BillingPeriodRange").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, BILLING_PERIOD_RANGE_FIELD));
    private final String arn;
    private final CustomLineItemBillingPeriodRange billingPeriodRange;

    private DeleteCustomLineItemRequest(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.billingPeriodRange = builder.billingPeriodRange;
    }

    public final String arn() {
        return this.arn;
    }

    public final CustomLineItemBillingPeriodRange billingPeriodRange() {
        return this.billingPeriodRange;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.billingPeriodRange());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteCustomLineItemRequest)) {
            return false;
        }
        DeleteCustomLineItemRequest other = (DeleteCustomLineItemRequest)((Object)obj);
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.billingPeriodRange(), other.billingPeriodRange());
    }

    public final String toString() {
        return ToString.builder((String)"DeleteCustomLineItemRequest").add("Arn", (Object)this.arn()).add("BillingPeriodRange", (Object)this.billingPeriodRange()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "BillingPeriodRange": {
                return Optional.ofNullable(clazz.cast(this.billingPeriodRange()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteCustomLineItemRequest, T> g) {
        return obj -> g.apply((DeleteCustomLineItemRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BillingconductorRequest.BuilderImpl
    implements Builder {
        private String arn;
        private CustomLineItemBillingPeriodRange billingPeriodRange;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteCustomLineItemRequest model) {
            super(model);
            this.arn(model.arn);
            this.billingPeriodRange(model.billingPeriodRange);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final CustomLineItemBillingPeriodRange.Builder getBillingPeriodRange() {
            return this.billingPeriodRange != null ? this.billingPeriodRange.toBuilder() : null;
        }

        public final void setBillingPeriodRange(CustomLineItemBillingPeriodRange.BuilderImpl billingPeriodRange) {
            this.billingPeriodRange = billingPeriodRange != null ? billingPeriodRange.build() : null;
        }

        @Override
        public final Builder billingPeriodRange(CustomLineItemBillingPeriodRange billingPeriodRange) {
            this.billingPeriodRange = billingPeriodRange;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteCustomLineItemRequest build() {
            return new DeleteCustomLineItemRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends BillingconductorRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteCustomLineItemRequest> {
        public Builder arn(String var1);

        public Builder billingPeriodRange(CustomLineItemBillingPeriodRange var1);

        default public Builder billingPeriodRange(Consumer<CustomLineItemBillingPeriodRange.Builder> billingPeriodRange) {
            return this.billingPeriodRange((CustomLineItemBillingPeriodRange)((CustomLineItemBillingPeriodRange.Builder)CustomLineItemBillingPeriodRange.builder().applyMutation(billingPeriodRange)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

