/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrock.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.bedrock.BedrockClient;
import software.amazon.awssdk.services.bedrock.internal.UserAgentUtils;
import software.amazon.awssdk.services.bedrock.model.ListModelCustomizationJobsRequest;
import software.amazon.awssdk.services.bedrock.model.ListModelCustomizationJobsResponse;
import software.amazon.awssdk.services.bedrock.model.ModelCustomizationJobSummary;

public class ListModelCustomizationJobsIterable
implements SdkIterable<ListModelCustomizationJobsResponse> {
    private final BedrockClient client;
    private final ListModelCustomizationJobsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListModelCustomizationJobsIterable(BedrockClient client, ListModelCustomizationJobsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListModelCustomizationJobsResponseFetcher();
    }

    public Iterator<ListModelCustomizationJobsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ModelCustomizationJobSummary> modelCustomizationJobSummaries() {
        Function<ListModelCustomizationJobsResponse, Iterator> getIterator = response -> {
            if (response != null && response.modelCustomizationJobSummaries() != null) {
                return response.modelCustomizationJobSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListModelCustomizationJobsResponseFetcher
    implements SyncPageFetcher<ListModelCustomizationJobsResponse> {
        private ListModelCustomizationJobsResponseFetcher() {
        }

        public boolean hasNextPage(ListModelCustomizationJobsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListModelCustomizationJobsResponse nextPage(ListModelCustomizationJobsResponse previousPage) {
            if (previousPage == null) {
                return ListModelCustomizationJobsIterable.this.client.listModelCustomizationJobs(ListModelCustomizationJobsIterable.this.firstRequest);
            }
            return ListModelCustomizationJobsIterable.this.client.listModelCustomizationJobs((ListModelCustomizationJobsRequest)((Object)ListModelCustomizationJobsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

