/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bcmdataexports.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.bcmdataexports.model.BcmDataExportsRequest;
import software.amazon.awssdk.services.bcmdataexports.model.TablePropertiesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetTableRequest
extends BcmDataExportsRequest
implements ToCopyableBuilder<Builder, GetTableRequest> {
    private static final SdkField<String> TABLE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TableName").getter(GetTableRequest.getter(GetTableRequest::tableName)).setter(GetTableRequest.setter(Builder::tableName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableName").build()}).build();
    private static final SdkField<Map<String, String>> TABLE_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("TableProperties").getter(GetTableRequest.getter(GetTableRequest::tableProperties)).setter(GetTableRequest.setter(Builder::tableProperties)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableProperties").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TABLE_NAME_FIELD, TABLE_PROPERTIES_FIELD));
    private final String tableName;
    private final Map<String, String> tableProperties;

    private GetTableRequest(BuilderImpl builder) {
        super(builder);
        this.tableName = builder.tableName;
        this.tableProperties = builder.tableProperties;
    }

    public final String tableName() {
        return this.tableName;
    }

    public final boolean hasTableProperties() {
        return this.tableProperties != null && !(this.tableProperties instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tableProperties() {
        return this.tableProperties;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.tableName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTableProperties() ? this.tableProperties() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetTableRequest)) {
            return false;
        }
        GetTableRequest other = (GetTableRequest)((Object)obj);
        return Objects.equals(this.tableName(), other.tableName()) && this.hasTableProperties() == other.hasTableProperties() && Objects.equals(this.tableProperties(), other.tableProperties());
    }

    public final String toString() {
        return ToString.builder((String)"GetTableRequest").add("TableName", (Object)this.tableName()).add("TableProperties", this.hasTableProperties() ? this.tableProperties() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TableName": {
                return Optional.ofNullable(clazz.cast(this.tableName()));
            }
            case "TableProperties": {
                return Optional.ofNullable(clazz.cast(this.tableProperties()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetTableRequest, T> g) {
        return obj -> g.apply((GetTableRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BcmDataExportsRequest.BuilderImpl
    implements Builder {
        private String tableName;
        private Map<String, String> tableProperties = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetTableRequest model) {
            super(model);
            this.tableName(model.tableName);
            this.tableProperties(model.tableProperties);
        }

        public final String getTableName() {
            return this.tableName;
        }

        public final void setTableName(String tableName) {
            this.tableName = tableName;
        }

        @Override
        public final Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public final Map<String, String> getTableProperties() {
            if (this.tableProperties instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tableProperties;
        }

        public final void setTableProperties(Map<String, String> tableProperties) {
            this.tableProperties = TablePropertiesCopier.copy(tableProperties);
        }

        @Override
        public final Builder tableProperties(Map<String, String> tableProperties) {
            this.tableProperties = TablePropertiesCopier.copy(tableProperties);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetTableRequest build() {
            return new GetTableRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends BcmDataExportsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetTableRequest> {
        public Builder tableName(String var1);

        public Builder tableProperties(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

