/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.batch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The type and amount of resources to assign to a container. The supported resources include <code>memory</code>,
 * <code>cpu</code>, and <code>nvidia.com/gpu</code>. For more information, see <a
 * href="https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/">Resource management for pods
 * and containers</a> in the <i>Kubernetes documentation</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EksContainerResourceRequirements implements SdkPojo, Serializable,
        ToCopyableBuilder<EksContainerResourceRequirements.Builder, EksContainerResourceRequirements> {
    private static final SdkField<Map<String, String>> LIMITS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("limits")
            .getter(getter(EksContainerResourceRequirements::limits))
            .setter(setter(Builder::limits))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("limits").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> REQUESTS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("requests")
            .getter(getter(EksContainerResourceRequirements::requests))
            .setter(setter(Builder::requests))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requests").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LIMITS_FIELD, REQUESTS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Map<String, String> limits;

    private final Map<String, String> requests;

    private EksContainerResourceRequirements(BuilderImpl builder) {
        this.limits = builder.limits;
        this.requests = builder.requests;
    }

    /**
     * For responses, this returns true if the service returned a value for the Limits property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasLimits() {
        return limits != null && !(limits instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The type and quantity of the resources to reserve for the container. The values vary based on the
     * <code>name</code> that's specified. Resources can be requested using either the <code>limits</code> or the
     * <code>requests</code> objects.
     * </p>
     * <dl>
     * <dt>memory</dt>
     * <dd>
     * <p>
     * The memory hard limit (in MiB) for the container, using whole integers, with a "Mi" suffix. If your container
     * attempts to exceed the memory specified, the container is terminated. You must specify at least 4 MiB of memory
     * for a job. <code>memory</code> can be specified in <code>limits</code>, <code>requests</code>, or both. If
     * <code>memory</code> is specified in both places, then the value that's specified in <code>limits</code> must be
     * equal to the value that's specified in <code>requests</code>.
     * </p>
     * <note>
     * <p>
     * To maximize your resource utilization, provide your jobs with as much memory as possible for the specific
     * instance type that you are using. To learn how, see <a
     * href="https://docs.aws.amazon.com/batch/latest/userguide/memory-management.html">Memory management</a> in the
     * <i>Batch User Guide</i>.
     * </p>
     * </note></dd>
     * <dt>cpu</dt>
     * <dd>
     * <p>
     * The number of CPUs that's reserved for the container. Values must be an even multiple of <code>0.25</code>.
     * <code>cpu</code> can be specified in <code>limits</code>, <code>requests</code>, or both. If <code>cpu</code> is
     * specified in both places, then the value that's specified in <code>limits</code> must be at least as large as the
     * value that's specified in <code>requests</code>.
     * </p>
     * </dd>
     * <dt>nvidia.com/gpu</dt>
     * <dd>
     * <p>
     * The number of GPUs that's reserved for the container. Values must be a whole integer. <code>memory</code> can be
     * specified in <code>limits</code>, <code>requests</code>, or both. If <code>memory</code> is specified in both
     * places, then the value that's specified in <code>limits</code> must be equal to the value that's specified in
     * <code>requests</code>.
     * </p>
     * </dd>
     * </dl>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLimits} method.
     * </p>
     * 
     * @return The type and quantity of the resources to reserve for the container. The values vary based on the
     *         <code>name</code> that's specified. Resources can be requested using either the <code>limits</code> or
     *         the <code>requests</code> objects.</p>
     *         <dl>
     *         <dt>memory</dt>
     *         <dd>
     *         <p>
     *         The memory hard limit (in MiB) for the container, using whole integers, with a "Mi" suffix. If your
     *         container attempts to exceed the memory specified, the container is terminated. You must specify at least
     *         4 MiB of memory for a job. <code>memory</code> can be specified in <code>limits</code>,
     *         <code>requests</code>, or both. If <code>memory</code> is specified in both places, then the value that's
     *         specified in <code>limits</code> must be equal to the value that's specified in <code>requests</code>.
     *         </p>
     *         <note>
     *         <p>
     *         To maximize your resource utilization, provide your jobs with as much memory as possible for the specific
     *         instance type that you are using. To learn how, see <a
     *         href="https://docs.aws.amazon.com/batch/latest/userguide/memory-management.html">Memory management</a> in
     *         the <i>Batch User Guide</i>.
     *         </p>
     *         </note></dd>
     *         <dt>cpu</dt>
     *         <dd>
     *         <p>
     *         The number of CPUs that's reserved for the container. Values must be an even multiple of
     *         <code>0.25</code>. <code>cpu</code> can be specified in <code>limits</code>, <code>requests</code>, or
     *         both. If <code>cpu</code> is specified in both places, then the value that's specified in
     *         <code>limits</code> must be at least as large as the value that's specified in <code>requests</code>.
     *         </p>
     *         </dd>
     *         <dt>nvidia.com/gpu</dt>
     *         <dd>
     *         <p>
     *         The number of GPUs that's reserved for the container. Values must be a whole integer. <code>memory</code>
     *         can be specified in <code>limits</code>, <code>requests</code>, or both. If <code>memory</code> is
     *         specified in both places, then the value that's specified in <code>limits</code> must be equal to the
     *         value that's specified in <code>requests</code>.
     *         </p>
     *         </dd>
     */
    public final Map<String, String> limits() {
        return limits;
    }

    /**
     * For responses, this returns true if the service returned a value for the Requests property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasRequests() {
        return requests != null && !(requests instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The type and quantity of the resources to request for the container. The values vary based on the
     * <code>name</code> that's specified. Resources can be requested by using either the <code>limits</code> or the
     * <code>requests</code> objects.
     * </p>
     * <dl>
     * <dt>memory</dt>
     * <dd>
     * <p>
     * The memory hard limit (in MiB) for the container, using whole integers, with a "Mi" suffix. If your container
     * attempts to exceed the memory specified, the container is terminated. You must specify at least 4 MiB of memory
     * for a job. <code>memory</code> can be specified in <code>limits</code>, <code>requests</code>, or both. If
     * <code>memory</code> is specified in both, then the value that's specified in <code>limits</code> must be equal to
     * the value that's specified in <code>requests</code>.
     * </p>
     * <note>
     * <p>
     * If you're trying to maximize your resource utilization by providing your jobs as much memory as possible for a
     * particular instance type, see <a
     * href="https://docs.aws.amazon.com/batch/latest/userguide/memory-management.html">Memory management</a> in the
     * <i>Batch User Guide</i>.
     * </p>
     * </note></dd>
     * <dt>cpu</dt>
     * <dd>
     * <p>
     * The number of CPUs that are reserved for the container. Values must be an even multiple of <code>0.25</code>.
     * <code>cpu</code> can be specified in <code>limits</code>, <code>requests</code>, or both. If <code>cpu</code> is
     * specified in both, then the value that's specified in <code>limits</code> must be at least as large as the value
     * that's specified in <code>requests</code>.
     * </p>
     * </dd>
     * <dt>nvidia.com/gpu</dt>
     * <dd>
     * <p>
     * The number of GPUs that are reserved for the container. Values must be a whole integer.
     * <code>nvidia.com/gpu</code> can be specified in <code>limits</code>, <code>requests</code>, or both. If
     * <code>nvidia.com/gpu</code> is specified in both, then the value that's specified in <code>limits</code> must be
     * equal to the value that's specified in <code>requests</code>.
     * </p>
     * </dd>
     * </dl>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRequests} method.
     * </p>
     * 
     * @return The type and quantity of the resources to request for the container. The values vary based on the
     *         <code>name</code> that's specified. Resources can be requested by using either the <code>limits</code> or
     *         the <code>requests</code> objects.</p>
     *         <dl>
     *         <dt>memory</dt>
     *         <dd>
     *         <p>
     *         The memory hard limit (in MiB) for the container, using whole integers, with a "Mi" suffix. If your
     *         container attempts to exceed the memory specified, the container is terminated. You must specify at least
     *         4 MiB of memory for a job. <code>memory</code> can be specified in <code>limits</code>,
     *         <code>requests</code>, or both. If <code>memory</code> is specified in both, then the value that's
     *         specified in <code>limits</code> must be equal to the value that's specified in <code>requests</code>.
     *         </p>
     *         <note>
     *         <p>
     *         If you're trying to maximize your resource utilization by providing your jobs as much memory as possible
     *         for a particular instance type, see <a
     *         href="https://docs.aws.amazon.com/batch/latest/userguide/memory-management.html">Memory management</a> in
     *         the <i>Batch User Guide</i>.
     *         </p>
     *         </note></dd>
     *         <dt>cpu</dt>
     *         <dd>
     *         <p>
     *         The number of CPUs that are reserved for the container. Values must be an even multiple of
     *         <code>0.25</code>. <code>cpu</code> can be specified in <code>limits</code>, <code>requests</code>, or
     *         both. If <code>cpu</code> is specified in both, then the value that's specified in <code>limits</code>
     *         must be at least as large as the value that's specified in <code>requests</code>.
     *         </p>
     *         </dd>
     *         <dt>nvidia.com/gpu</dt>
     *         <dd>
     *         <p>
     *         The number of GPUs that are reserved for the container. Values must be a whole integer.
     *         <code>nvidia.com/gpu</code> can be specified in <code>limits</code>, <code>requests</code>, or both. If
     *         <code>nvidia.com/gpu</code> is specified in both, then the value that's specified in <code>limits</code>
     *         must be equal to the value that's specified in <code>requests</code>.
     *         </p>
     *         </dd>
     */
    public final Map<String, String> requests() {
        return requests;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasLimits() ? limits() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasRequests() ? requests() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EksContainerResourceRequirements)) {
            return false;
        }
        EksContainerResourceRequirements other = (EksContainerResourceRequirements) obj;
        return hasLimits() == other.hasLimits() && Objects.equals(limits(), other.limits())
                && hasRequests() == other.hasRequests() && Objects.equals(requests(), other.requests());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EksContainerResourceRequirements").add("Limits", hasLimits() ? limits() : null)
                .add("Requests", hasRequests() ? requests() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "limits":
            return Optional.ofNullable(clazz.cast(limits()));
        case "requests":
            return Optional.ofNullable(clazz.cast(requests()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EksContainerResourceRequirements, T> g) {
        return obj -> g.apply((EksContainerResourceRequirements) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EksContainerResourceRequirements> {
        /**
         * <p>
         * The type and quantity of the resources to reserve for the container. The values vary based on the
         * <code>name</code> that's specified. Resources can be requested using either the <code>limits</code> or the
         * <code>requests</code> objects.
         * </p>
         * <dl>
         * <dt>memory</dt>
         * <dd>
         * <p>
         * The memory hard limit (in MiB) for the container, using whole integers, with a "Mi" suffix. If your container
         * attempts to exceed the memory specified, the container is terminated. You must specify at least 4 MiB of
         * memory for a job. <code>memory</code> can be specified in <code>limits</code>, <code>requests</code>, or
         * both. If <code>memory</code> is specified in both places, then the value that's specified in
         * <code>limits</code> must be equal to the value that's specified in <code>requests</code>.
         * </p>
         * <note>
         * <p>
         * To maximize your resource utilization, provide your jobs with as much memory as possible for the specific
         * instance type that you are using. To learn how, see <a
         * href="https://docs.aws.amazon.com/batch/latest/userguide/memory-management.html">Memory management</a> in the
         * <i>Batch User Guide</i>.
         * </p>
         * </note></dd>
         * <dt>cpu</dt>
         * <dd>
         * <p>
         * The number of CPUs that's reserved for the container. Values must be an even multiple of <code>0.25</code>.
         * <code>cpu</code> can be specified in <code>limits</code>, <code>requests</code>, or both. If <code>cpu</code>
         * is specified in both places, then the value that's specified in <code>limits</code> must be at least as large
         * as the value that's specified in <code>requests</code>.
         * </p>
         * </dd>
         * <dt>nvidia.com/gpu</dt>
         * <dd>
         * <p>
         * The number of GPUs that's reserved for the container. Values must be a whole integer. <code>memory</code> can
         * be specified in <code>limits</code>, <code>requests</code>, or both. If <code>memory</code> is specified in
         * both places, then the value that's specified in <code>limits</code> must be equal to the value that's
         * specified in <code>requests</code>.
         * </p>
         * </dd>
         * </dl>
         * 
         * @param limits
         *        The type and quantity of the resources to reserve for the container. The values vary based on the
         *        <code>name</code> that's specified. Resources can be requested using either the <code>limits</code> or
         *        the <code>requests</code> objects.</p>
         *        <dl>
         *        <dt>memory</dt>
         *        <dd>
         *        <p>
         *        The memory hard limit (in MiB) for the container, using whole integers, with a "Mi" suffix. If your
         *        container attempts to exceed the memory specified, the container is terminated. You must specify at
         *        least 4 MiB of memory for a job. <code>memory</code> can be specified in <code>limits</code>,
         *        <code>requests</code>, or both. If <code>memory</code> is specified in both places, then the value
         *        that's specified in <code>limits</code> must be equal to the value that's specified in
         *        <code>requests</code>.
         *        </p>
         *        <note>
         *        <p>
         *        To maximize your resource utilization, provide your jobs with as much memory as possible for the
         *        specific instance type that you are using. To learn how, see <a
         *        href="https://docs.aws.amazon.com/batch/latest/userguide/memory-management.html">Memory management</a>
         *        in the <i>Batch User Guide</i>.
         *        </p>
         *        </note></dd>
         *        <dt>cpu</dt>
         *        <dd>
         *        <p>
         *        The number of CPUs that's reserved for the container. Values must be an even multiple of
         *        <code>0.25</code>. <code>cpu</code> can be specified in <code>limits</code>, <code>requests</code>, or
         *        both. If <code>cpu</code> is specified in both places, then the value that's specified in
         *        <code>limits</code> must be at least as large as the value that's specified in <code>requests</code>.
         *        </p>
         *        </dd>
         *        <dt>nvidia.com/gpu</dt>
         *        <dd>
         *        <p>
         *        The number of GPUs that's reserved for the container. Values must be a whole integer.
         *        <code>memory</code> can be specified in <code>limits</code>, <code>requests</code>, or both. If
         *        <code>memory</code> is specified in both places, then the value that's specified in
         *        <code>limits</code> must be equal to the value that's specified in <code>requests</code>.
         *        </p>
         *        </dd>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder limits(Map<String, String> limits);

        /**
         * <p>
         * The type and quantity of the resources to request for the container. The values vary based on the
         * <code>name</code> that's specified. Resources can be requested by using either the <code>limits</code> or the
         * <code>requests</code> objects.
         * </p>
         * <dl>
         * <dt>memory</dt>
         * <dd>
         * <p>
         * The memory hard limit (in MiB) for the container, using whole integers, with a "Mi" suffix. If your container
         * attempts to exceed the memory specified, the container is terminated. You must specify at least 4 MiB of
         * memory for a job. <code>memory</code> can be specified in <code>limits</code>, <code>requests</code>, or
         * both. If <code>memory</code> is specified in both, then the value that's specified in <code>limits</code>
         * must be equal to the value that's specified in <code>requests</code>.
         * </p>
         * <note>
         * <p>
         * If you're trying to maximize your resource utilization by providing your jobs as much memory as possible for
         * a particular instance type, see <a
         * href="https://docs.aws.amazon.com/batch/latest/userguide/memory-management.html">Memory management</a> in the
         * <i>Batch User Guide</i>.
         * </p>
         * </note></dd>
         * <dt>cpu</dt>
         * <dd>
         * <p>
         * The number of CPUs that are reserved for the container. Values must be an even multiple of <code>0.25</code>.
         * <code>cpu</code> can be specified in <code>limits</code>, <code>requests</code>, or both. If <code>cpu</code>
         * is specified in both, then the value that's specified in <code>limits</code> must be at least as large as the
         * value that's specified in <code>requests</code>.
         * </p>
         * </dd>
         * <dt>nvidia.com/gpu</dt>
         * <dd>
         * <p>
         * The number of GPUs that are reserved for the container. Values must be a whole integer.
         * <code>nvidia.com/gpu</code> can be specified in <code>limits</code>, <code>requests</code>, or both. If
         * <code>nvidia.com/gpu</code> is specified in both, then the value that's specified in <code>limits</code> must
         * be equal to the value that's specified in <code>requests</code>.
         * </p>
         * </dd>
         * </dl>
         * 
         * @param requests
         *        The type and quantity of the resources to request for the container. The values vary based on the
         *        <code>name</code> that's specified. Resources can be requested by using either the <code>limits</code>
         *        or the <code>requests</code> objects.</p>
         *        <dl>
         *        <dt>memory</dt>
         *        <dd>
         *        <p>
         *        The memory hard limit (in MiB) for the container, using whole integers, with a "Mi" suffix. If your
         *        container attempts to exceed the memory specified, the container is terminated. You must specify at
         *        least 4 MiB of memory for a job. <code>memory</code> can be specified in <code>limits</code>,
         *        <code>requests</code>, or both. If <code>memory</code> is specified in both, then the value that's
         *        specified in <code>limits</code> must be equal to the value that's specified in <code>requests</code>.
         *        </p>
         *        <note>
         *        <p>
         *        If you're trying to maximize your resource utilization by providing your jobs as much memory as
         *        possible for a particular instance type, see <a
         *        href="https://docs.aws.amazon.com/batch/latest/userguide/memory-management.html">Memory management</a>
         *        in the <i>Batch User Guide</i>.
         *        </p>
         *        </note></dd>
         *        <dt>cpu</dt>
         *        <dd>
         *        <p>
         *        The number of CPUs that are reserved for the container. Values must be an even multiple of
         *        <code>0.25</code>. <code>cpu</code> can be specified in <code>limits</code>, <code>requests</code>, or
         *        both. If <code>cpu</code> is specified in both, then the value that's specified in <code>limits</code>
         *        must be at least as large as the value that's specified in <code>requests</code>.
         *        </p>
         *        </dd>
         *        <dt>nvidia.com/gpu</dt>
         *        <dd>
         *        <p>
         *        The number of GPUs that are reserved for the container. Values must be a whole integer.
         *        <code>nvidia.com/gpu</code> can be specified in <code>limits</code>, <code>requests</code>, or both.
         *        If <code>nvidia.com/gpu</code> is specified in both, then the value that's specified in
         *        <code>limits</code> must be equal to the value that's specified in <code>requests</code>.
         *        </p>
         *        </dd>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requests(Map<String, String> requests);
    }

    static final class BuilderImpl implements Builder {
        private Map<String, String> limits = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, String> requests = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(EksContainerResourceRequirements model) {
            limits(model.limits);
            requests(model.requests);
        }

        public final Map<String, String> getLimits() {
            if (limits instanceof SdkAutoConstructMap) {
                return null;
            }
            return limits;
        }

        public final void setLimits(Map<String, String> limits) {
            this.limits = EksLimitsCopier.copy(limits);
        }

        @Override
        public final Builder limits(Map<String, String> limits) {
            this.limits = EksLimitsCopier.copy(limits);
            return this;
        }

        public final Map<String, String> getRequests() {
            if (requests instanceof SdkAutoConstructMap) {
                return null;
            }
            return requests;
        }

        public final void setRequests(Map<String, String> requests) {
            this.requests = EksRequestsCopier.copy(requests);
        }

        @Override
        public final Builder requests(Map<String, String> requests) {
            this.requests = EksRequestsCopier.copy(requests);
            return this;
        }

        @Override
        public EksContainerResourceRequirements build() {
            return new EksContainerResourceRequirements(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
