/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.batch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.batch.model.ArrayProperties;
import software.amazon.awssdk.services.batch.model.BatchRequest;
import software.amazon.awssdk.services.batch.model.ContainerOverrides;
import software.amazon.awssdk.services.batch.model.EksPropertiesOverride;
import software.amazon.awssdk.services.batch.model.JobDependency;
import software.amazon.awssdk.services.batch.model.JobDependencyListCopier;
import software.amazon.awssdk.services.batch.model.JobTimeout;
import software.amazon.awssdk.services.batch.model.NodeOverrides;
import software.amazon.awssdk.services.batch.model.ParametersMapCopier;
import software.amazon.awssdk.services.batch.model.RetryStrategy;
import software.amazon.awssdk.services.batch.model.TagrisTagsMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SubmitJobRequest
extends BatchRequest
implements ToCopyableBuilder<Builder, SubmitJobRequest> {
    private static final SdkField<String> JOB_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("jobName").getter(SubmitJobRequest.getter(SubmitJobRequest::jobName)).setter(SubmitJobRequest.setter(Builder::jobName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobName").build()}).build();
    private static final SdkField<String> JOB_QUEUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("jobQueue").getter(SubmitJobRequest.getter(SubmitJobRequest::jobQueue)).setter(SubmitJobRequest.setter(Builder::jobQueue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobQueue").build()}).build();
    private static final SdkField<String> SHARE_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("shareIdentifier").getter(SubmitJobRequest.getter(SubmitJobRequest::shareIdentifier)).setter(SubmitJobRequest.setter(Builder::shareIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("shareIdentifier").build()}).build();
    private static final SdkField<Integer> SCHEDULING_PRIORITY_OVERRIDE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("schedulingPriorityOverride").getter(SubmitJobRequest.getter(SubmitJobRequest::schedulingPriorityOverride)).setter(SubmitJobRequest.setter(Builder::schedulingPriorityOverride)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("schedulingPriorityOverride").build()}).build();
    private static final SdkField<ArrayProperties> ARRAY_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("arrayProperties").getter(SubmitJobRequest.getter(SubmitJobRequest::arrayProperties)).setter(SubmitJobRequest.setter(Builder::arrayProperties)).constructor(ArrayProperties::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arrayProperties").build()}).build();
    private static final SdkField<List<JobDependency>> DEPENDS_ON_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("dependsOn").getter(SubmitJobRequest.getter(SubmitJobRequest::dependsOn)).setter(SubmitJobRequest.setter(Builder::dependsOn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dependsOn").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(JobDependency::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> JOB_DEFINITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("jobDefinition").getter(SubmitJobRequest.getter(SubmitJobRequest::jobDefinition)).setter(SubmitJobRequest.setter(Builder::jobDefinition)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobDefinition").build()}).build();
    private static final SdkField<Map<String, String>> PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("parameters").getter(SubmitJobRequest.getter(SubmitJobRequest::parameters)).setter(SubmitJobRequest.setter(Builder::parameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parameters").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<ContainerOverrides> CONTAINER_OVERRIDES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("containerOverrides").getter(SubmitJobRequest.getter(SubmitJobRequest::containerOverrides)).setter(SubmitJobRequest.setter(Builder::containerOverrides)).constructor(ContainerOverrides::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("containerOverrides").build()}).build();
    private static final SdkField<NodeOverrides> NODE_OVERRIDES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("nodeOverrides").getter(SubmitJobRequest.getter(SubmitJobRequest::nodeOverrides)).setter(SubmitJobRequest.setter(Builder::nodeOverrides)).constructor(NodeOverrides::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nodeOverrides").build()}).build();
    private static final SdkField<RetryStrategy> RETRY_STRATEGY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("retryStrategy").getter(SubmitJobRequest.getter(SubmitJobRequest::retryStrategy)).setter(SubmitJobRequest.setter(Builder::retryStrategy)).constructor(RetryStrategy::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("retryStrategy").build()}).build();
    private static final SdkField<Boolean> PROPAGATE_TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("propagateTags").getter(SubmitJobRequest.getter(SubmitJobRequest::propagateTags)).setter(SubmitJobRequest.setter(Builder::propagateTags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("propagateTags").build()}).build();
    private static final SdkField<JobTimeout> TIMEOUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("timeout").getter(SubmitJobRequest.getter(SubmitJobRequest::timeout)).setter(SubmitJobRequest.setter(Builder::timeout)).constructor(JobTimeout::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timeout").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(SubmitJobRequest.getter(SubmitJobRequest::tags)).setter(SubmitJobRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<EksPropertiesOverride> EKS_PROPERTIES_OVERRIDE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("eksPropertiesOverride").getter(SubmitJobRequest.getter(SubmitJobRequest::eksPropertiesOverride)).setter(SubmitJobRequest.setter(Builder::eksPropertiesOverride)).constructor(EksPropertiesOverride::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eksPropertiesOverride").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_NAME_FIELD, JOB_QUEUE_FIELD, SHARE_IDENTIFIER_FIELD, SCHEDULING_PRIORITY_OVERRIDE_FIELD, ARRAY_PROPERTIES_FIELD, DEPENDS_ON_FIELD, JOB_DEFINITION_FIELD, PARAMETERS_FIELD, CONTAINER_OVERRIDES_FIELD, NODE_OVERRIDES_FIELD, RETRY_STRATEGY_FIELD, PROPAGATE_TAGS_FIELD, TIMEOUT_FIELD, TAGS_FIELD, EKS_PROPERTIES_OVERRIDE_FIELD));
    private final String jobName;
    private final String jobQueue;
    private final String shareIdentifier;
    private final Integer schedulingPriorityOverride;
    private final ArrayProperties arrayProperties;
    private final List<JobDependency> dependsOn;
    private final String jobDefinition;
    private final Map<String, String> parameters;
    private final ContainerOverrides containerOverrides;
    private final NodeOverrides nodeOverrides;
    private final RetryStrategy retryStrategy;
    private final Boolean propagateTags;
    private final JobTimeout timeout;
    private final Map<String, String> tags;
    private final EksPropertiesOverride eksPropertiesOverride;

    private SubmitJobRequest(BuilderImpl builder) {
        super(builder);
        this.jobName = builder.jobName;
        this.jobQueue = builder.jobQueue;
        this.shareIdentifier = builder.shareIdentifier;
        this.schedulingPriorityOverride = builder.schedulingPriorityOverride;
        this.arrayProperties = builder.arrayProperties;
        this.dependsOn = builder.dependsOn;
        this.jobDefinition = builder.jobDefinition;
        this.parameters = builder.parameters;
        this.containerOverrides = builder.containerOverrides;
        this.nodeOverrides = builder.nodeOverrides;
        this.retryStrategy = builder.retryStrategy;
        this.propagateTags = builder.propagateTags;
        this.timeout = builder.timeout;
        this.tags = builder.tags;
        this.eksPropertiesOverride = builder.eksPropertiesOverride;
    }

    public final String jobName() {
        return this.jobName;
    }

    public final String jobQueue() {
        return this.jobQueue;
    }

    public final String shareIdentifier() {
        return this.shareIdentifier;
    }

    public final Integer schedulingPriorityOverride() {
        return this.schedulingPriorityOverride;
    }

    public final ArrayProperties arrayProperties() {
        return this.arrayProperties;
    }

    public final boolean hasDependsOn() {
        return this.dependsOn != null && !(this.dependsOn instanceof SdkAutoConstructList);
    }

    public final List<JobDependency> dependsOn() {
        return this.dependsOn;
    }

    public final String jobDefinition() {
        return this.jobDefinition;
    }

    public final boolean hasParameters() {
        return this.parameters != null && !(this.parameters instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> parameters() {
        return this.parameters;
    }

    public final ContainerOverrides containerOverrides() {
        return this.containerOverrides;
    }

    public final NodeOverrides nodeOverrides() {
        return this.nodeOverrides;
    }

    public final RetryStrategy retryStrategy() {
        return this.retryStrategy;
    }

    public final Boolean propagateTags() {
        return this.propagateTags;
    }

    public final JobTimeout timeout() {
        return this.timeout;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final EksPropertiesOverride eksPropertiesOverride() {
        return this.eksPropertiesOverride;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.jobName());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobQueue());
        hashCode = 31 * hashCode + Objects.hashCode(this.shareIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.schedulingPriorityOverride());
        hashCode = 31 * hashCode + Objects.hashCode(this.arrayProperties());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDependsOn() ? this.dependsOn() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.jobDefinition());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasParameters() ? this.parameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.containerOverrides());
        hashCode = 31 * hashCode + Objects.hashCode(this.nodeOverrides());
        hashCode = 31 * hashCode + Objects.hashCode(this.retryStrategy());
        hashCode = 31 * hashCode + Objects.hashCode(this.propagateTags());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeout());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.eksPropertiesOverride());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SubmitJobRequest)) {
            return false;
        }
        SubmitJobRequest other = (SubmitJobRequest)((Object)obj);
        return Objects.equals(this.jobName(), other.jobName()) && Objects.equals(this.jobQueue(), other.jobQueue()) && Objects.equals(this.shareIdentifier(), other.shareIdentifier()) && Objects.equals(this.schedulingPriorityOverride(), other.schedulingPriorityOverride()) && Objects.equals(this.arrayProperties(), other.arrayProperties()) && this.hasDependsOn() == other.hasDependsOn() && Objects.equals(this.dependsOn(), other.dependsOn()) && Objects.equals(this.jobDefinition(), other.jobDefinition()) && this.hasParameters() == other.hasParameters() && Objects.equals(this.parameters(), other.parameters()) && Objects.equals(this.containerOverrides(), other.containerOverrides()) && Objects.equals(this.nodeOverrides(), other.nodeOverrides()) && Objects.equals(this.retryStrategy(), other.retryStrategy()) && Objects.equals(this.propagateTags(), other.propagateTags()) && Objects.equals(this.timeout(), other.timeout()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.eksPropertiesOverride(), other.eksPropertiesOverride());
    }

    public final String toString() {
        return ToString.builder((String)"SubmitJobRequest").add("JobName", (Object)this.jobName()).add("JobQueue", (Object)this.jobQueue()).add("ShareIdentifier", (Object)this.shareIdentifier()).add("SchedulingPriorityOverride", (Object)this.schedulingPriorityOverride()).add("ArrayProperties", (Object)this.arrayProperties()).add("DependsOn", this.hasDependsOn() ? this.dependsOn() : null).add("JobDefinition", (Object)this.jobDefinition()).add("Parameters", this.hasParameters() ? this.parameters() : null).add("ContainerOverrides", (Object)this.containerOverrides()).add("NodeOverrides", (Object)this.nodeOverrides()).add("RetryStrategy", (Object)this.retryStrategy()).add("PropagateTags", (Object)this.propagateTags()).add("Timeout", (Object)this.timeout()).add("Tags", this.hasTags() ? this.tags() : null).add("EksPropertiesOverride", (Object)this.eksPropertiesOverride()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "jobName": {
                return Optional.ofNullable(clazz.cast(this.jobName()));
            }
            case "jobQueue": {
                return Optional.ofNullable(clazz.cast(this.jobQueue()));
            }
            case "shareIdentifier": {
                return Optional.ofNullable(clazz.cast(this.shareIdentifier()));
            }
            case "schedulingPriorityOverride": {
                return Optional.ofNullable(clazz.cast(this.schedulingPriorityOverride()));
            }
            case "arrayProperties": {
                return Optional.ofNullable(clazz.cast(this.arrayProperties()));
            }
            case "dependsOn": {
                return Optional.ofNullable(clazz.cast(this.dependsOn()));
            }
            case "jobDefinition": {
                return Optional.ofNullable(clazz.cast(this.jobDefinition()));
            }
            case "parameters": {
                return Optional.ofNullable(clazz.cast(this.parameters()));
            }
            case "containerOverrides": {
                return Optional.ofNullable(clazz.cast(this.containerOverrides()));
            }
            case "nodeOverrides": {
                return Optional.ofNullable(clazz.cast(this.nodeOverrides()));
            }
            case "retryStrategy": {
                return Optional.ofNullable(clazz.cast(this.retryStrategy()));
            }
            case "propagateTags": {
                return Optional.ofNullable(clazz.cast(this.propagateTags()));
            }
            case "timeout": {
                return Optional.ofNullable(clazz.cast(this.timeout()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "eksPropertiesOverride": {
                return Optional.ofNullable(clazz.cast(this.eksPropertiesOverride()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SubmitJobRequest, T> g) {
        return obj -> g.apply((SubmitJobRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BatchRequest.BuilderImpl
    implements Builder {
        private String jobName;
        private String jobQueue;
        private String shareIdentifier;
        private Integer schedulingPriorityOverride;
        private ArrayProperties arrayProperties;
        private List<JobDependency> dependsOn = DefaultSdkAutoConstructList.getInstance();
        private String jobDefinition;
        private Map<String, String> parameters = DefaultSdkAutoConstructMap.getInstance();
        private ContainerOverrides containerOverrides;
        private NodeOverrides nodeOverrides;
        private RetryStrategy retryStrategy;
        private Boolean propagateTags;
        private JobTimeout timeout;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private EksPropertiesOverride eksPropertiesOverride;

        private BuilderImpl() {
        }

        private BuilderImpl(SubmitJobRequest model) {
            super(model);
            this.jobName(model.jobName);
            this.jobQueue(model.jobQueue);
            this.shareIdentifier(model.shareIdentifier);
            this.schedulingPriorityOverride(model.schedulingPriorityOverride);
            this.arrayProperties(model.arrayProperties);
            this.dependsOn(model.dependsOn);
            this.jobDefinition(model.jobDefinition);
            this.parameters(model.parameters);
            this.containerOverrides(model.containerOverrides);
            this.nodeOverrides(model.nodeOverrides);
            this.retryStrategy(model.retryStrategy);
            this.propagateTags(model.propagateTags);
            this.timeout(model.timeout);
            this.tags(model.tags);
            this.eksPropertiesOverride(model.eksPropertiesOverride);
        }

        public final String getJobName() {
            return this.jobName;
        }

        public final void setJobName(String jobName) {
            this.jobName = jobName;
        }

        @Override
        public final Builder jobName(String jobName) {
            this.jobName = jobName;
            return this;
        }

        public final String getJobQueue() {
            return this.jobQueue;
        }

        public final void setJobQueue(String jobQueue) {
            this.jobQueue = jobQueue;
        }

        @Override
        public final Builder jobQueue(String jobQueue) {
            this.jobQueue = jobQueue;
            return this;
        }

        public final String getShareIdentifier() {
            return this.shareIdentifier;
        }

        public final void setShareIdentifier(String shareIdentifier) {
            this.shareIdentifier = shareIdentifier;
        }

        @Override
        public final Builder shareIdentifier(String shareIdentifier) {
            this.shareIdentifier = shareIdentifier;
            return this;
        }

        public final Integer getSchedulingPriorityOverride() {
            return this.schedulingPriorityOverride;
        }

        public final void setSchedulingPriorityOverride(Integer schedulingPriorityOverride) {
            this.schedulingPriorityOverride = schedulingPriorityOverride;
        }

        @Override
        public final Builder schedulingPriorityOverride(Integer schedulingPriorityOverride) {
            this.schedulingPriorityOverride = schedulingPriorityOverride;
            return this;
        }

        public final ArrayProperties.Builder getArrayProperties() {
            return this.arrayProperties != null ? this.arrayProperties.toBuilder() : null;
        }

        public final void setArrayProperties(ArrayProperties.BuilderImpl arrayProperties) {
            this.arrayProperties = arrayProperties != null ? arrayProperties.build() : null;
        }

        @Override
        public final Builder arrayProperties(ArrayProperties arrayProperties) {
            this.arrayProperties = arrayProperties;
            return this;
        }

        public final List<JobDependency.Builder> getDependsOn() {
            List<JobDependency.Builder> result = JobDependencyListCopier.copyToBuilder(this.dependsOn);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDependsOn(Collection<JobDependency.BuilderImpl> dependsOn) {
            this.dependsOn = JobDependencyListCopier.copyFromBuilder(dependsOn);
        }

        @Override
        public final Builder dependsOn(Collection<JobDependency> dependsOn) {
            this.dependsOn = JobDependencyListCopier.copy(dependsOn);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dependsOn(JobDependency ... dependsOn) {
            this.dependsOn(Arrays.asList(dependsOn));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dependsOn(Consumer<JobDependency.Builder> ... dependsOn) {
            this.dependsOn(Stream.of(dependsOn).map(c -> (JobDependency)((JobDependency.Builder)JobDependency.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getJobDefinition() {
            return this.jobDefinition;
        }

        public final void setJobDefinition(String jobDefinition) {
            this.jobDefinition = jobDefinition;
        }

        @Override
        public final Builder jobDefinition(String jobDefinition) {
            this.jobDefinition = jobDefinition;
            return this;
        }

        public final Map<String, String> getParameters() {
            if (this.parameters instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.parameters;
        }

        public final void setParameters(Map<String, String> parameters) {
            this.parameters = ParametersMapCopier.copy(parameters);
        }

        @Override
        public final Builder parameters(Map<String, String> parameters) {
            this.parameters = ParametersMapCopier.copy(parameters);
            return this;
        }

        public final ContainerOverrides.Builder getContainerOverrides() {
            return this.containerOverrides != null ? this.containerOverrides.toBuilder() : null;
        }

        public final void setContainerOverrides(ContainerOverrides.BuilderImpl containerOverrides) {
            this.containerOverrides = containerOverrides != null ? containerOverrides.build() : null;
        }

        @Override
        public final Builder containerOverrides(ContainerOverrides containerOverrides) {
            this.containerOverrides = containerOverrides;
            return this;
        }

        public final NodeOverrides.Builder getNodeOverrides() {
            return this.nodeOverrides != null ? this.nodeOverrides.toBuilder() : null;
        }

        public final void setNodeOverrides(NodeOverrides.BuilderImpl nodeOverrides) {
            this.nodeOverrides = nodeOverrides != null ? nodeOverrides.build() : null;
        }

        @Override
        public final Builder nodeOverrides(NodeOverrides nodeOverrides) {
            this.nodeOverrides = nodeOverrides;
            return this;
        }

        public final RetryStrategy.Builder getRetryStrategy() {
            return this.retryStrategy != null ? this.retryStrategy.toBuilder() : null;
        }

        public final void setRetryStrategy(RetryStrategy.BuilderImpl retryStrategy) {
            this.retryStrategy = retryStrategy != null ? retryStrategy.build() : null;
        }

        @Override
        public final Builder retryStrategy(RetryStrategy retryStrategy) {
            this.retryStrategy = retryStrategy;
            return this;
        }

        public final Boolean getPropagateTags() {
            return this.propagateTags;
        }

        public final void setPropagateTags(Boolean propagateTags) {
            this.propagateTags = propagateTags;
        }

        @Override
        public final Builder propagateTags(Boolean propagateTags) {
            this.propagateTags = propagateTags;
            return this;
        }

        public final JobTimeout.Builder getTimeout() {
            return this.timeout != null ? this.timeout.toBuilder() : null;
        }

        public final void setTimeout(JobTimeout.BuilderImpl timeout) {
            this.timeout = timeout != null ? timeout.build() : null;
        }

        @Override
        public final Builder timeout(JobTimeout timeout) {
            this.timeout = timeout;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagrisTagsMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagrisTagsMapCopier.copy(tags);
            return this;
        }

        public final EksPropertiesOverride.Builder getEksPropertiesOverride() {
            return this.eksPropertiesOverride != null ? this.eksPropertiesOverride.toBuilder() : null;
        }

        public final void setEksPropertiesOverride(EksPropertiesOverride.BuilderImpl eksPropertiesOverride) {
            this.eksPropertiesOverride = eksPropertiesOverride != null ? eksPropertiesOverride.build() : null;
        }

        @Override
        public final Builder eksPropertiesOverride(EksPropertiesOverride eksPropertiesOverride) {
            this.eksPropertiesOverride = eksPropertiesOverride;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SubmitJobRequest build() {
            return new SubmitJobRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends BatchRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, SubmitJobRequest> {
        public Builder jobName(String var1);

        public Builder jobQueue(String var1);

        public Builder shareIdentifier(String var1);

        public Builder schedulingPriorityOverride(Integer var1);

        public Builder arrayProperties(ArrayProperties var1);

        default public Builder arrayProperties(Consumer<ArrayProperties.Builder> arrayProperties) {
            return this.arrayProperties((ArrayProperties)((ArrayProperties.Builder)ArrayProperties.builder().applyMutation(arrayProperties)).build());
        }

        public Builder dependsOn(Collection<JobDependency> var1);

        public Builder dependsOn(JobDependency ... var1);

        public Builder dependsOn(Consumer<JobDependency.Builder> ... var1);

        public Builder jobDefinition(String var1);

        public Builder parameters(Map<String, String> var1);

        public Builder containerOverrides(ContainerOverrides var1);

        default public Builder containerOverrides(Consumer<ContainerOverrides.Builder> containerOverrides) {
            return this.containerOverrides((ContainerOverrides)((ContainerOverrides.Builder)ContainerOverrides.builder().applyMutation(containerOverrides)).build());
        }

        public Builder nodeOverrides(NodeOverrides var1);

        default public Builder nodeOverrides(Consumer<NodeOverrides.Builder> nodeOverrides) {
            return this.nodeOverrides((NodeOverrides)((NodeOverrides.Builder)NodeOverrides.builder().applyMutation(nodeOverrides)).build());
        }

        public Builder retryStrategy(RetryStrategy var1);

        default public Builder retryStrategy(Consumer<RetryStrategy.Builder> retryStrategy) {
            return this.retryStrategy((RetryStrategy)((RetryStrategy.Builder)RetryStrategy.builder().applyMutation(retryStrategy)).build());
        }

        public Builder propagateTags(Boolean var1);

        public Builder timeout(JobTimeout var1);

        default public Builder timeout(Consumer<JobTimeout.Builder> timeout) {
            return this.timeout((JobTimeout)((JobTimeout.Builder)JobTimeout.builder().applyMutation(timeout)).build());
        }

        public Builder tags(Map<String, String> var1);

        public Builder eksPropertiesOverride(EksPropertiesOverride var1);

        default public Builder eksPropertiesOverride(Consumer<EksPropertiesOverride.Builder> eksPropertiesOverride) {
            return this.eksPropertiesOverride((EksPropertiesOverride)((EksPropertiesOverride.Builder)EksPropertiesOverride.builder().applyMutation(eksPropertiesOverride)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

