/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.backupstorage.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListObjectsRequest extends BackupStorageRequest implements
        ToCopyableBuilder<ListObjectsRequest.Builder, ListObjectsRequest> {
    private static final SdkField<String> STORAGE_JOB_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StorageJobId").getter(getter(ListObjectsRequest::storageJobId)).setter(setter(Builder::storageJobId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("jobId").build()).build();

    private static final SdkField<String> STARTING_OBJECT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StartingObjectName").getter(getter(ListObjectsRequest::startingObjectName))
            .setter(setter(Builder::startingObjectName))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("starting-object-name").build())
            .build();

    private static final SdkField<String> STARTING_OBJECT_PREFIX_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("StartingObjectPrefix")
            .getter(getter(ListObjectsRequest::startingObjectPrefix))
            .setter(setter(Builder::startingObjectPrefix))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("starting-object-prefix").build())
            .build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListObjectsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("max-results").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListObjectsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("next-token").build()).build();

    private static final SdkField<Instant> CREATED_BEFORE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedBefore").getter(getter(ListObjectsRequest::createdBefore)).setter(setter(Builder::createdBefore))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("created-before").build())
            .build();

    private static final SdkField<Instant> CREATED_AFTER_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedAfter").getter(getter(ListObjectsRequest::createdAfter)).setter(setter(Builder::createdAfter))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("created-after").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STORAGE_JOB_ID_FIELD,
            STARTING_OBJECT_NAME_FIELD, STARTING_OBJECT_PREFIX_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, CREATED_BEFORE_FIELD,
            CREATED_AFTER_FIELD));

    private final String storageJobId;

    private final String startingObjectName;

    private final String startingObjectPrefix;

    private final Integer maxResults;

    private final String nextToken;

    private final Instant createdBefore;

    private final Instant createdAfter;

    private ListObjectsRequest(BuilderImpl builder) {
        super(builder);
        this.storageJobId = builder.storageJobId;
        this.startingObjectName = builder.startingObjectName;
        this.startingObjectPrefix = builder.startingObjectPrefix;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.createdBefore = builder.createdBefore;
        this.createdAfter = builder.createdAfter;
    }

    /**
     * Storage job id
     * 
     * @return Storage job id
     */
    public final String storageJobId() {
        return storageJobId;
    }

    /**
     * Optional, specifies the starting Object name to list from. Ignored if NextToken is not NULL
     * 
     * @return Optional, specifies the starting Object name to list from. Ignored if NextToken is not NULL
     */
    public final String startingObjectName() {
        return startingObjectName;
    }

    /**
     * Optional, specifies the starting Object prefix to list from. Ignored if NextToken is not NULL
     * 
     * @return Optional, specifies the starting Object prefix to list from. Ignored if NextToken is not NULL
     */
    public final String startingObjectPrefix() {
        return startingObjectPrefix;
    }

    /**
     * Maximum objects count
     * 
     * @return Maximum objects count
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * Pagination token
     * 
     * @return Pagination token
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * (Optional) Created before filter
     * 
     * @return (Optional) Created before filter
     */
    public final Instant createdBefore() {
        return createdBefore;
    }

    /**
     * (Optional) Created after filter
     * 
     * @return (Optional) Created after filter
     */
    public final Instant createdAfter() {
        return createdAfter;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(storageJobId());
        hashCode = 31 * hashCode + Objects.hashCode(startingObjectName());
        hashCode = 31 * hashCode + Objects.hashCode(startingObjectPrefix());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(createdBefore());
        hashCode = 31 * hashCode + Objects.hashCode(createdAfter());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListObjectsRequest)) {
            return false;
        }
        ListObjectsRequest other = (ListObjectsRequest) obj;
        return Objects.equals(storageJobId(), other.storageJobId())
                && Objects.equals(startingObjectName(), other.startingObjectName())
                && Objects.equals(startingObjectPrefix(), other.startingObjectPrefix())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(createdBefore(), other.createdBefore()) && Objects.equals(createdAfter(), other.createdAfter());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListObjectsRequest").add("StorageJobId", storageJobId())
                .add("StartingObjectName", startingObjectName()).add("StartingObjectPrefix", startingObjectPrefix())
                .add("MaxResults", maxResults()).add("NextToken", nextToken()).add("CreatedBefore", createdBefore())
                .add("CreatedAfter", createdAfter()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StorageJobId":
            return Optional.ofNullable(clazz.cast(storageJobId()));
        case "StartingObjectName":
            return Optional.ofNullable(clazz.cast(startingObjectName()));
        case "StartingObjectPrefix":
            return Optional.ofNullable(clazz.cast(startingObjectPrefix()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "CreatedBefore":
            return Optional.ofNullable(clazz.cast(createdBefore()));
        case "CreatedAfter":
            return Optional.ofNullable(clazz.cast(createdAfter()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListObjectsRequest, T> g) {
        return obj -> g.apply((ListObjectsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BackupStorageRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListObjectsRequest> {
        /**
         * Storage job id
         * 
         * @param storageJobId
         *        Storage job id
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storageJobId(String storageJobId);

        /**
         * Optional, specifies the starting Object name to list from. Ignored if NextToken is not NULL
         * 
         * @param startingObjectName
         *        Optional, specifies the starting Object name to list from. Ignored if NextToken is not NULL
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startingObjectName(String startingObjectName);

        /**
         * Optional, specifies the starting Object prefix to list from. Ignored if NextToken is not NULL
         * 
         * @param startingObjectPrefix
         *        Optional, specifies the starting Object prefix to list from. Ignored if NextToken is not NULL
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startingObjectPrefix(String startingObjectPrefix);

        /**
         * Maximum objects count
         * 
         * @param maxResults
         *        Maximum objects count
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * Pagination token
         * 
         * @param nextToken
         *        Pagination token
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * (Optional) Created before filter
         * 
         * @param createdBefore
         *        (Optional) Created before filter
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdBefore(Instant createdBefore);

        /**
         * (Optional) Created after filter
         * 
         * @param createdAfter
         *        (Optional) Created after filter
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAfter(Instant createdAfter);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends BackupStorageRequest.BuilderImpl implements Builder {
        private String storageJobId;

        private String startingObjectName;

        private String startingObjectPrefix;

        private Integer maxResults;

        private String nextToken;

        private Instant createdBefore;

        private Instant createdAfter;

        private BuilderImpl() {
        }

        private BuilderImpl(ListObjectsRequest model) {
            super(model);
            storageJobId(model.storageJobId);
            startingObjectName(model.startingObjectName);
            startingObjectPrefix(model.startingObjectPrefix);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
            createdBefore(model.createdBefore);
            createdAfter(model.createdAfter);
        }

        public final String getStorageJobId() {
            return storageJobId;
        }

        public final void setStorageJobId(String storageJobId) {
            this.storageJobId = storageJobId;
        }

        @Override
        public final Builder storageJobId(String storageJobId) {
            this.storageJobId = storageJobId;
            return this;
        }

        public final String getStartingObjectName() {
            return startingObjectName;
        }

        public final void setStartingObjectName(String startingObjectName) {
            this.startingObjectName = startingObjectName;
        }

        @Override
        public final Builder startingObjectName(String startingObjectName) {
            this.startingObjectName = startingObjectName;
            return this;
        }

        public final String getStartingObjectPrefix() {
            return startingObjectPrefix;
        }

        public final void setStartingObjectPrefix(String startingObjectPrefix) {
            this.startingObjectPrefix = startingObjectPrefix;
        }

        @Override
        public final Builder startingObjectPrefix(String startingObjectPrefix) {
            this.startingObjectPrefix = startingObjectPrefix;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Instant getCreatedBefore() {
            return createdBefore;
        }

        public final void setCreatedBefore(Instant createdBefore) {
            this.createdBefore = createdBefore;
        }

        @Override
        public final Builder createdBefore(Instant createdBefore) {
            this.createdBefore = createdBefore;
            return this;
        }

        public final Instant getCreatedAfter() {
            return createdAfter;
        }

        public final void setCreatedAfter(Instant createdAfter) {
            this.createdAfter = createdAfter;
        }

        @Override
        public final Builder createdAfter(Instant createdAfter) {
            this.createdAfter = createdAfter;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListObjectsRequest build() {
            return new ListObjectsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
